/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.log;

import cn.hutool.core.lang.caller.CallerUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.log.level.Level;

public final class StaticLog {
    private static final String FQCN = StaticLog.class.getName();

    private StaticLog() {
    }

    public static void trace(String format, Object ... arguments) {
        StaticLog.trace(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void trace(Log log, String format, Object ... arguments) {
        log.trace(FQCN, null, format, arguments);
    }

    public static void debug(String format, Object ... arguments) {
        StaticLog.debug(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void debug(Log log, String format, Object ... arguments) {
        log.debug(FQCN, null, format, arguments);
    }

    public static void info(String format, Object ... arguments) {
        StaticLog.info(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void info(Log log, String format, Object ... arguments) {
        log.info(FQCN, null, format, arguments);
    }

    public static void warn(String format, Object ... arguments) {
        StaticLog.warn(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void warn(Throwable e, String format, Object ... arguments) {
        StaticLog.warn(LogFactory.get(CallerUtil.getCallerCaller()), e, StrUtil.format((CharSequence)format, arguments), new Object[0]);
    }

    public static void warn(Log log, String format, Object ... arguments) {
        StaticLog.warn(log, null, format, arguments);
    }

    public static void warn(Log log, Throwable e, String format, Object ... arguments) {
        log.warn(FQCN, e, format, arguments);
    }

    public static void error(Throwable e) {
        StaticLog.error(LogFactory.get(CallerUtil.getCallerCaller()), e);
    }

    public static void error(String format, Object ... arguments) {
        StaticLog.error(LogFactory.get(CallerUtil.getCallerCaller()), format, arguments);
    }

    public static void error(Throwable e, String format, Object ... arguments) {
        StaticLog.error(LogFactory.get(CallerUtil.getCallerCaller()), e, format, arguments);
    }

    public static void error(Log log, Throwable e) {
        StaticLog.error(log, e, e.getMessage(), new Object[0]);
    }

    public static void error(Log log, String format, Object ... arguments) {
        StaticLog.error(log, null, format, arguments);
    }

    public static void error(Log log, Throwable e, String format, Object ... arguments) {
        log.error(FQCN, e, format, arguments);
    }

    public static void log(Level level, Throwable t, String format, Object ... arguments) {
        LogFactory.get(CallerUtil.getCallerCaller()).log(FQCN, level, t, format, arguments);
    }

    @Deprecated
    public static Log get(Class<?> clazz) {
        return LogFactory.get(clazz);
    }

    @Deprecated
    public static Log get(String name) {
        return LogFactory.get(name);
    }

    @Deprecated
    public static Log get() {
        return LogFactory.get(CallerUtil.getCallerCaller());
    }
}

