/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean.copier.provider;

import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanValueProvider
implements ValueProvider<String> {
    private final Object source;
    private final boolean ignoreError;
    final Map<String, BeanDesc.PropDesc> sourcePdMap;

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError) {
        this.source = bean;
        this.ignoreError = ignoreError;
        this.sourcePdMap = BeanUtil.getBeanDesc(this.source.getClass()).getPropMap(ignoreCase);
    }

    @Override
    public Object value(String key, Type valueType) {
        Method getter;
        BeanDesc.PropDesc sourcePd = this.sourcePdMap.get(key);
        if (null == sourcePd && (Boolean.class == valueType || Boolean.TYPE == valueType)) {
            sourcePd = this.sourcePdMap.get(StrUtil.upperFirstAndAddPre(key, "is"));
        }
        Object result = null;
        if (null != sourcePd && null != (getter = sourcePd.getGetter())) {
            block5: {
                try {
                    result = getter.invoke(this.source, new Object[0]);
                }
                catch (Exception e) {
                    if (this.ignoreError) break block5;
                    throw new UtilException(e, "Inject [{}] error!", key);
                }
            }
            Object convertValue = Convert.convertWithCheck(valueType, result, null, this.ignoreError);
            if (null != convertValue) {
                result = convertValue;
            }
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        return this.sourcePdMap.containsKey(key) || this.sourcePdMap.containsKey(StrUtil.upperFirstAndAddPre(key, "is"));
    }
}

