/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelBase;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.WorkbookUtil;
import cn.hutool.poi.excel.cell.CellEditor;
import cn.hutool.poi.excel.cell.CellHandler;
import cn.hutool.poi.excel.cell.CellUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader
extends ExcelBase<ExcelReader> {
    private boolean ignoreEmptyRow = true;
    private CellEditor cellEditor;
    private Map<String, String> headerAlias = new HashMap<String, String>();

    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(FileUtil.file(excelFilePath), sheetIndex);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(WorkbookUtil.createBook(bookFile), sheetIndex);
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(WorkbookUtil.createBook(bookFile), sheetName);
    }

    @Deprecated
    public ExcelReader(InputStream bookStream, int sheetIndex, boolean closeAfterRead) {
        this(WorkbookUtil.createBook(bookStream), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, int sheetIndex) {
        this(WorkbookUtil.createBook(bookStream), sheetIndex);
    }

    @Deprecated
    public ExcelReader(InputStream bookStream, String sheetName, boolean closeAfterRead) {
        this(WorkbookUtil.createBook(bookStream), sheetName);
    }

    public ExcelReader(InputStream bookStream, String sheetName) {
        this(WorkbookUtil.createBook(bookStream), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(book.getSheetAt(sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(book.getSheet(sheetName));
    }

    public ExcelReader(Sheet sheet) {
        super(sheet);
    }

    public boolean isIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public ExcelReader setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
        return this;
    }

    public ExcelReader setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }

    public Map<String, String> getHeaderAlias() {
        return this.headerAlias;
    }

    public ExcelReader setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelReader addHeaderAlias(String header, String alias) {
        this.headerAlias.put(header, alias);
        return this;
    }

    public ExcelReader removeHeaderAlias(String header) {
        this.headerAlias.remove(header);
        return this;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        this.checkNotClosed();
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        boolean isFirstLine = true;
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList = this.readRow(i);
            if (!CollUtil.isNotEmpty(rowList) && this.ignoreEmptyRow) continue;
            if (null == rowList) {
                rowList = new ArrayList<Object>(0);
            }
            if (isFirstLine) {
                isFirstLine = false;
                if (MapUtil.isNotEmpty(this.headerAlias)) {
                    rowList = this.aliasHeader(rowList);
                }
            }
            resultList.add(rowList);
        }
        return resultList;
    }

    public void read(CellHandler cellHandler) {
        this.read(0, Integer.MAX_VALUE, cellHandler);
    }

    public void read(int startRowIndex, int endRowIndex, CellHandler cellHandler) {
        this.checkNotClosed();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = this.sheet.getRow(y);
            short columnSize = row.getLastCellNum();
            for (short x = 0; x < columnSize; x = (short)(x + 1)) {
                Cell cell = row.getCell((int)x);
                cellHandler.handle(cell, CellUtil.getCellValue(cell));
            }
        }
    }

    public List<Map<String, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public List<Map<String, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        this.checkNotClosed();
        int firstRowNum = this.sheet.getFirstRowNum();
        int lastRowNum = this.sheet.getLastRowNum();
        if (headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is lower than first row index {}.", headerRowIndex, firstRowNum));
        }
        if (headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Header row index {} is greater than last row index {}.", headerRowIndex, firstRowNum));
        }
        startRowIndex = Math.max(startRowIndex, firstRowNum);
        endRowIndex = Math.min(endRowIndex, lastRowNum);
        List<Object> headerList = this.readRow(this.sheet.getRow(headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == headerRowIndex || !CollUtil.isNotEmpty(rowList = this.readRow(this.sheet.getRow(i))) && this.ignoreEmptyRow) continue;
            result.add(IterUtil.toMap(this.aliasHeader(headerList), rowList, true));
        }
        return result;
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        this.checkNotClosed();
        List<Map<String, Object>> mapList = this.read(headerRowIndex, startRowIndex, endRowIndex);
        if (Map.class.isAssignableFrom(beanType)) {
            return mapList;
        }
        ArrayList<T> beanList = new ArrayList<T>(mapList.size());
        for (Map<String, Object> map : mapList) {
            beanList.add(BeanUtil.toBean(map, beanType));
        }
        return beanList;
    }

    public String readAsText(boolean withSheetName) {
        ExcelExtractor extractor = this.getExtractor();
        extractor.setIncludeSheetNames(withSheetName);
        return extractor.getText();
    }

    public ExcelExtractor getExtractor() {
        Workbook wb = this.workbook;
        Object extractor = wb instanceof HSSFWorkbook ? new org.apache.poi.hssf.extractor.ExcelExtractor((HSSFWorkbook)wb) : new XSSFExcelExtractor((XSSFWorkbook)wb);
        return extractor;
    }

    public List<Object> readRow(int rowIndex) {
        return this.readRow(this.sheet.getRow(rowIndex));
    }

    public Object readCellValue(int x, int y) {
        return CellUtil.getCellValue(this.getCell(x, y), this.cellEditor);
    }

    public ExcelWriter getWriter() {
        return new ExcelWriter(this.sheet);
    }

    private List<Object> readRow(Row row) {
        return RowUtil.readRow(row, this.cellEditor);
    }

    private List<String> aliasHeader(List<Object> headerList) {
        if (CollUtil.isEmpty(headerList)) {
            return new ArrayList<String>(0);
        }
        int size = headerList.size();
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.aliasHeader(headerList.get(i), i));
        }
        return result;
    }

    private String aliasHeader(Object headerObj, int index) {
        if (null == headerObj) {
            return ExcelUtil.indexToColName(index);
        }
        String header = headerObj.toString();
        return ObjectUtil.defaultIfNull(this.headerAlias.get(header), header);
    }

    private void checkNotClosed() {
        Assert.isFalse(this.isClosed, "ExcelReader has been closed!", new Object[0]);
    }
}

