/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.ProgressInputStream;
import cn.xuyanwu.spring.file.storage.ProgressListener;
import cn.xuyanwu.spring.file.storage.aspect.DownloadAspectChain;
import cn.xuyanwu.spring.file.storage.aspect.DownloadThAspectChain;
import cn.xuyanwu.spring.file.storage.aspect.FileStorageAspect;
import cn.xuyanwu.spring.file.storage.exception.FileStorageRuntimeException;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Downloader {
    public static final int TARGET_FILE = 1;
    public static final int TARGET_TH_FILE = 2;
    private final FileStorage fileStorage;
    private final List<FileStorageAspect> aspectList;
    private final FileInfo fileInfo;
    private final Integer target;
    private ProgressListener progressListener;

    public Downloader(FileInfo fileInfo, List<FileStorageAspect> aspectList, FileStorage fileStorage, Integer target) {
        this.fileStorage = fileStorage;
        this.aspectList = aspectList;
        this.fileInfo = fileInfo;
        this.target = target;
    }

    public Downloader setProgressMonitor(Consumer<Long> progressListener) {
        return this.setProgressMonitor((Long progressSize, Long allSize) -> progressListener.accept((Long)progressSize));
    }

    public Downloader setProgressMonitor(final BiConsumer<Long, Long> progressListener) {
        return this.setProgressMonitor(new ProgressListener(){

            @Override
            public void start() {
            }

            @Override
            public void progress(long progressSize, long allSize) {
                progressListener.accept(progressSize, allSize);
            }

            @Override
            public void finish() {
            }
        });
    }

    public Downloader setProgressMonitor(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public void inputStream(Consumer<InputStream> consumer) {
        if (this.target == 1) {
            new DownloadAspectChain(this.aspectList, (_fileInfo, _fileStorage, _consumer) -> _fileStorage.download(_fileInfo, _consumer)).next(this.fileInfo, this.fileStorage, in -> consumer.accept(this.progressListener == null ? in : new ProgressInputStream((InputStream)in, this.progressListener, this.fileInfo.getSize())));
        } else if (this.target == 2) {
            new DownloadThAspectChain(this.aspectList, (_fileInfo, _fileStorage, _consumer) -> _fileStorage.downloadTh(_fileInfo, _consumer)).next(this.fileInfo, this.fileStorage, in -> consumer.accept(this.progressListener == null ? in : new ProgressInputStream((InputStream)in, this.progressListener, this.fileInfo.getThSize())));
        } else {
            throw new FileStorageRuntimeException("\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u4e0b\u8f7d\u76ee\u6807\uff0c\u8bf7\u8bbe\u7f6e target \u53c2\u6570\uff01");
        }
    }

    public byte[] bytes() {
        byte[][] bytes = new byte[1][];
        this.inputStream(in -> {
            bytes[0] = IoUtil.readBytes((InputStream)in);
        });
        return bytes[0];
    }

    public void file(File file) {
        this.inputStream(in -> FileUtil.writeFromStream((InputStream)in, (File)file));
    }

    public void file(String filename) {
        this.inputStream(in -> FileUtil.writeFromStream((InputStream)in, (String)filename));
    }

    public void outputStream(OutputStream out) {
        this.inputStream(in -> IoUtil.copy((InputStream)in, (OutputStream)out));
    }
}

