/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.util.jar.JarFile;

public class AgentMain {
    public static void premain(String agentArguments, Instrumentation instrumentation) {
        AgentMain.init(agentArguments, instrumentation);
    }

    public static void agentmain(String agentArguments, Instrumentation instrumentation) {
        AgentMain.init(agentArguments, instrumentation);
    }

    public static synchronized void init(String agentArguments, Instrumentation instrumentation) {
        if (Boolean.getBoolean("ElasticApm.attached")) {
            return;
        }
        try {
            FileSystems.getDefault();
            File agentJarFile = AgentMain.getAgentJarFile();
            try (JarFile jarFile = new JarFile(agentJarFile);){
                instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
            }
            Class.forName("co.elastic.apm.agent.bci.ElasticApmAgent", true, null).getMethod("initialize", String.class, Instrumentation.class, File.class).invoke(null, agentArguments, instrumentation, agentJarFile);
            System.setProperty("ElasticApm.attached", Boolean.TRUE.toString());
        }
        catch (Exception e) {
            System.err.println("Failed to start agent");
            e.printStackTrace();
        }
    }

    private static File getAgentJarFile() throws URISyntaxException {
        File agentJar = new File(AgentMain.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        if (!agentJar.getName().endsWith(".jar")) {
            throw new IllegalStateException("Agent is not a jar file: " + agentJar);
        }
        return agentJar.getAbsoluteFile();
    }
}

