/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.annotation.AnnotationDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.ParameterDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class SimpleMethodSignatureOffsetMappingFactory
implements Advice.OffsetMapping.Factory<SimpleMethodSignature> {
    @Override
    public Class<SimpleMethodSignature> getAnnotationType() {
        return SimpleMethodSignature.class;
    }

    @Override
    public Advice.OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<SimpleMethodSignature> annotation, Advice.OffsetMapping.Factory.AdviceType adviceType) {
        return new Advice.OffsetMapping(){

            @Override
            public Advice.OffsetMapping.Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, Advice.ArgumentHandler argumentHandler, Advice.OffsetMapping.Sort sort) {
                String className = instrumentedMethod.getDeclaringType().getTypeName();
                String simpleClassName = className.substring(className.lastIndexOf(36) + 1);
                simpleClassName = simpleClassName.substring(simpleClassName.lastIndexOf(46) + 1);
                String signature = String.format("%s#%s", simpleClassName, instrumentedMethod.getName());
                return Advice.OffsetMapping.Target.ForStackManipulation.of(signature);
            }
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface SimpleMethodSignature {
    }
}

