/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.bytebuddy;

import co.elastic.apm.agent.shaded.bytebuddy.agent.builder.AgentBuilder;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.pool.TypePool;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class SoftlyReferencingTypePoolCache
extends AgentBuilder.PoolStrategy.WithTypePoolCache {
    private final WeakConcurrentMap<ClassLoader, CacheProviderWrapper> cacheProviders = new WeakConcurrentMap(false);
    private final ElementMatcher<ClassLoader> ignoredClassLoaders;

    public SoftlyReferencingTypePoolCache(TypePool.Default.ReaderMode readerMode, final int clearIfNotAccessedSinceMinutes, ElementMatcher.Junction<ClassLoader> ignoredClassLoaders) {
        super(readerMode);
        ExecutorUtils.createSingleThreadSchedulingDeamonPool("type-cache-pool-cleaner", 1).scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SoftlyReferencingTypePoolCache.this.clearIfNotAccessedSince(clearIfNotAccessedSinceMinutes);
                SoftlyReferencingTypePoolCache.this.cacheProviders.expungeStaleEntries();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        this.ignoredClassLoaders = ignoredClassLoaders;
    }

    @Override
    protected TypePool.CacheProvider locate(ClassLoader classLoader) {
        TypePool.CacheProvider cacheProvider;
        if (this.ignoredClassLoaders.matches(classLoader)) {
            return TypePool.CacheProvider.Simple.withObjectType();
        }
        CacheProviderWrapper cacheProviderRef = this.cacheProviders.get(classLoader = classLoader == null ? this.getBootstrapMarkerLoader() : classLoader);
        if (cacheProviderRef == null || cacheProviderRef.get() == null) {
            cacheProviderRef = new CacheProviderWrapper();
            this.cacheProviders.put(classLoader, cacheProviderRef);
            cacheProviderRef = this.cacheProviders.get(classLoader);
        }
        return (cacheProvider = cacheProviderRef.get()) != null ? cacheProvider : TypePool.CacheProvider.Simple.withObjectType();
    }

    void clearIfNotAccessedSince(long clearIfNotAccessedSinceMinutes) {
        for (Map.Entry<ClassLoader, CacheProviderWrapper> entry : this.cacheProviders) {
            if (System.currentTimeMillis() < entry.getValue().getLastAccess() + TimeUnit.MINUTES.toMillis(clearIfNotAccessedSinceMinutes)) continue;
            this.cacheProviders.remove(entry.getKey());
        }
    }

    WeakConcurrentMap<ClassLoader, CacheProviderWrapper> getCacheProviders() {
        return this.cacheProviders;
    }

    private ClassLoader getBootstrapMarkerLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    private static class CacheProviderWrapper {
        private final AtomicLong lastAccess = new AtomicLong(System.currentTimeMillis());
        private final SoftReference<TypePool.CacheProvider> delegate = new SoftReference<TypePool.CacheProvider.Simple>(new TypePool.CacheProvider.Simple());

        private CacheProviderWrapper() {
        }

        long getLastAccess() {
            return this.lastAccess.get();
        }

        @Nullable
        TypePool.CacheProvider get() {
            return this.delegate.get();
        }
    }
}

