/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.methodmatching.MethodMatcher;
import co.elastic.apm.agent.bci.methodmatching.configuration.MethodMatcherValueConverter;
import co.elastic.apm.agent.configuration.ServiceNameUtil;
import co.elastic.apm.agent.configuration.converter.ListValueConverter;
import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.configuration.converter.TimeDurationValueConverter;
import co.elastic.apm.agent.configuration.validation.RangeValidator;
import co.elastic.apm.agent.configuration.validation.RegexValidator;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcherValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.MapValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.converter.StringValueConverter;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class CoreConfiguration
extends ConfigurationOptionProvider {
    public static final String ACTIVE = "active";
    public static final String INSTRUMENT = "instrument";
    public static final String SERVICE_NAME = "service_name";
    public static final String SERVICE_NODE_NAME = "service_node_name";
    public static final String SAMPLE_RATE = "transaction_sample_rate";
    private static final String CORE_CATEGORY = "Core";
    private static final String DEFAULT_CONFIG_FILE = "_AGENT_HOME_/elasticapm.properties";
    public static final String CONFIG_FILE = "config_file";
    private final ConfigurationOption<Boolean> active = ConfigurationOption.booleanOption().key("active").configurationCategory("Core").description("A boolean specifying if the agent should be active or not.\nWhen active, the agent instruments incoming HTTP requests, tracks errors and collects and sends metrics.\nWhen inactive, the agent works as a noop, not collecting data and not communicating with the APM sever.\nAs this is a reversible switch, agent threads are not being killed when inactivated, but they will be \nmostly idle in this state, so the overhead should be negligible.\n\nYou can use this setting to dynamically disable Elastic APM at runtime.").dynamic(true).buildWithDefault(true);
    private final ConfigurationOption<Boolean> instrument = ConfigurationOption.booleanOption().key("instrument").configurationCategory("Core").description("A boolean specifying if the agent should instrument the application to collect performance metrics for the app. When set to false, Elastic APM will not affect your application at all.\n\nNOTE: Both active and instrument needs to be true for instrumentation to be running.").buildWithDefault(true);
    private final ConfigurationOption<String> serviceName = ConfigurationOption.stringOption().key("service_name").configurationCategory("Core").label("The name of your service").description("This is used to keep all the errors and transactions of your service together\nand is the primary filter in the Elastic APM user interface.\n\nThe service name must conform to this regular expression: `^[a-zA-Z0-9 _-]+$`.\nIn less regexy terms:\nYour service name must only contain characters from the ASCII alphabet, numbers, dashes, underscores and spaces.\n\nNOTE: When relying on auto-discovery of the service name in Servlet environments (including Spring Boot),\nthere is currently a caveat related to metrics.\nThe consequence is that the 'Metrics' tab of a service does not show process-global metrics like CPU utilization.\nThe reason is that metrics are reported with the detected default service name for the JVM,\nfor example `tomcat-application`.\nThat is because there may be multiple web applications deployed to a single JVM/servlet container.\nHowever, you can view those metrics by selecting the `tomcat-application` service name, for example.\nFuture versions of the Elastic APM stack will have better support for that scenario.\nA workaround is to explicitly set the `service_name` which means all applications deployed to the same servlet container will have the same name\nor to disable the corresponding `*-service-name` detecting instrumentations via <<config-disable-instrumentations>>.\n\nNOTE: Service name auto discovery mechanisms require APM Server 7.0+.").addValidator(RegexValidator.of("^[a-zA-Z0-9 _-]+$", "Your service name \"{0}\" must only contain characters from the ASCII alphabet, numbers, dashes, underscores and spaces")).buildWithDefault(ServiceNameUtil.getDefaultServiceName());
    private final ConfigurationOption<String> serviceNodeName = ConfigurationOption.stringOption().key("service_node_name").configurationCategory("Core").label("A unique name for the service node").description("If set, this name is used to distinguish between different nodes of a service, \ntherefore it should be unique for each JVM within a service. \nIf not set, data aggregations will be done based on a container ID (where valid) or on the reported \nhostname (automatically discovered or manually configured through <<config-hostname, `hostname`>>). \n\nNOTE: JVM metrics views rely on aggregations that are based on the service node name. \nIf you have multiple JVMs installed on the same host reporting data for the same service name, \nyou must set a unique node name for each in order to view metrics at the JVM level.\n\nNOTE: Metrics views can utilize this configuration since APM Server 7.5").tags("added[1.11.0]").build();
    private final ConfigurationOption<String> serviceVersion = ConfigurationOption.stringOption().key("service_version").configurationCategory("Core").description("A version string for the currently deployed version of the service. If you don\u2019t version your deployments, the recommended value for this field is the commit identifier of the deployed revision, e.g. the output of git rev-parse HEAD.").build();
    private final ConfigurationOption<String> hostname = ConfigurationOption.stringOption().key("hostname").tags("added[1.10.0]").configurationCategory("Core").description("Allows for the reported hostname to be manually specified. If unset the hostname will be looked up.").build();
    private final ConfigurationOption<String> environment = ConfigurationOption.stringOption().key("environment").configurationCategory("Core").description("The name of the environment this service is deployed in, e.g. \"production\" or \"staging\".\n\nEnvironments allow you to easily filter data on a global level in the APM app.\nIt's important to be consistent when naming environments across agents.\nSee {apm-app-ref}/filters.html#environment-selector[environment selector] in the APM app for more information.\n\nNOTE: This feature is fully supported in the APM app in Kibana versions >= 7.2.\nYou must use the query bar to filter for a specific environment in versions prior to 7.2.").build();
    private final ConfigurationOption<Double> sampleRate = ConfigurationOption.doubleOption().key("transaction_sample_rate").aliasKeys("sample_rate").configurationCategory("Core").tags("performance").description("By default, the agent will sample every transaction (e.g. request to your service). To reduce overhead and storage requirements, you can set the sample rate to a value between 0.0 and 1.0. We still record overall time and the result for unsampled transactions, but no context information, labels, or spans.").dynamic(true).addValidator(RangeValidator.isInRange(0.0, 1.0)).buildWithDefault(1.0);
    private final ConfigurationOption<Integer> transactionMaxSpans = ConfigurationOption.integerOption().key("transaction_max_spans").configurationCategory("Core").tags("performance").description("Limits the amount of spans that are recorded per transaction.\n\nThis is helpful in cases where a transaction creates a very high amount of spans (e.g. thousands of SQL queries).\n\nSetting an upper limit will prevent overloading the agent and the APM server with too much work for such edge cases.\n\nA message will be logged when the max number of spans has been exceeded but only at a rate of once every " + TimeUnit.MICROSECONDS.toMinutes(ElasticApmTracer.MAX_LOG_INTERVAL_MICRO_SECS) + " minutes to ensure performance is not impacted.").dynamic(true).buildWithDefault(500);
    private final ConfigurationOption<List<WildcardMatcher>> sanitizeFieldNames = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("sanitize_field_names").configurationCategory("Core").description("Sometimes it is necessary to sanitize the data sent to Elastic APM,\ne.g. remove sensitive data.\n\nConfigure a list of wildcard patterns of field names which should be sanitized.\nThese apply for example to HTTP headers and `application/x-www-form-urlencoded` data.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.\n\nNOTE: Data in the query string is considered non-sensitive,\nas sensitive information should not be sent in the query string.\nSee https://www.owasp.org/index.php/Information_exposure_through_query_strings_in_url for more information\n\nNOTE: Review the data captured by Elastic APM carefully to make sure it does not capture sensitive information.\nIf you do find sensitive data in the Elasticsearch index,\nyou should add an additional entry to this list (make sure to also include the default entries).").dynamic(true).tags("security").buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("password"), WildcardMatcher.valueOf("passwd"), WildcardMatcher.valueOf("pwd"), WildcardMatcher.valueOf("secret"), WildcardMatcher.valueOf("*key"), WildcardMatcher.valueOf("*token*"), WildcardMatcher.valueOf("*session*"), WildcardMatcher.valueOf("*credit*"), WildcardMatcher.valueOf("*card*"), WildcardMatcher.valueOf("authorization"), WildcardMatcher.valueOf("set-cookie")));
    private final ConfigurationOption<Collection<String>> disabledInstrumentations = ConfigurationOption.stringsOption().key("disable_instrumentations").aliasKeys("disabled_instrumentations").configurationCategory("Core").description("A list of instrumentations which should be disabled.\nValid options are ${allInstrumentationGroupNames}.\nIf you want to try out incubating features, set the value to an empty string.").buildWithDefault(Collections.singleton("incubating"));
    private final ConfigurationOption<List<WildcardMatcher>> unnestExceptions = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("unnest_exceptions").configurationCategory("Core").description("When reporting exceptions,\nun-nests the exceptions matching the wildcard pattern.\nThis can come in handy for Spring's `org.springframework.web.util.NestedServletException`,\nfor example.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Collections.singletonList(WildcardMatcher.valueOf("(?-i)*Nested*Exception")));
    private final ConfigurationOption<List<WildcardMatcher>> ignoreExceptions = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("ignore_exceptions").tags("added[1.11.0]").configurationCategory("Core").description("A list of exceptions that should be ignored and not reported as errors.\nThis allows to ignore exceptions thrown in regular control flow that are not actual errors\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.\n\nExamples:\n\n - `com.mycompany.ExceptionToIgnore`: using fully qualified name\n - `*ExceptionToIgnore`: using wildcard to avoid package name\n - `*exceptiontoignore`: case-insensitive by default\n\nNOTE: Exception inheritance is not supported, thus you have to explicitly list all the thrown exception types").dynamic(true).buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<EventType> captureBody = ConfigurationOption.enumOption(EventType.class).key("capture_body").configurationCategory("Core").tags("performance").description("For transactions that are HTTP requests, the Java agent can optionally capture the request body (e.g. POST \nvariables). For transactions that are initiated by receiving a JMS text message, the agent can capture the \ntextual message body.\n\nIf the HTTP request or the JMS message has a body and this setting is disabled, the body will be shown as [REDACTED].\n\nThis option is case-insensitive.\n\nNOTE: Currently, only UTF-8 encoded plain text HTTP content types are supported.\nThe option <<config-capture-body-content-types>> determines which content types are captured.\n\nWARNING: Request bodies often contain sensitive values like passwords, credit card numbers etc.\nIf your service handles data like this, we advise to only enable this feature with care.\nTurning on body capturing can also significantly increase the overhead in terms of heap usage,\nnetwork utilisation and Elasticsearch index size.").dynamic(true).buildWithDefault(EventType.OFF);
    private final ConfigurationOption<Boolean> captureHeaders = ConfigurationOption.booleanOption().key("capture_headers").configurationCategory("Core").tags("performance").description("If set to `true`, the agent will capture request and response headers, including cookies.\n\nNOTE: Setting this to `false` reduces network bandwidth, disk space and object allocations.").dynamic(true).buildWithDefault(true);
    private final ConfigurationOption<Map<String, String>> globalLabels = ConfigurationOption.builder(new MapValueConverter<String, String>(StringValueConverter.INSTANCE, StringValueConverter.INSTANCE, "=", ","), Map.class).key("global_labels").tags("added[1.7.0, Requires APM Server 7.2+]").configurationCategory("Core").description("Labels added to all events, with the format `key=value[,key=value[,...]]`.\nAny labels set by application via the API will override global labels with the same keys.\n\nNOTE: This feature requires APM Server 7.2+").dynamic(false).buildWithDefault(Collections.emptyMap());
    private final ConfigurationOption<Boolean> typePoolCache = ConfigurationOption.booleanOption().key("enable_type_pool_cache").configurationCategory("Core").tags("internal").description("When enabled, configures Byte Buddy to use a type pool cache.").buildWithDefault(true);
    private final ConfigurationOption<Boolean> typeMatchingWithNamePreFilter = ConfigurationOption.booleanOption().key("enable_type_matching_name_pre_filtering").configurationCategory("Core").tags("internal").description("When enabled, applies cheap name-based matchers to types before checking the type hierarchy.\nThis speeds up matching but can lead to false negatives,\nfor example when a javax.servlet.Servlet does not contain the word 'Servlet' in the class name.").buildWithDefault(true);
    private final ConfigurationOption<Boolean> classLoadingMatchingPreFilter = ConfigurationOption.booleanOption().key("enable_class_loading_pre_filtering").configurationCategory("Core").tags("internal").description("When enabled, applies class loader match before checking the type hierarchy that relies on CL cache.\nThis speeds up matching but can lead to class-loading-related side effects, for example when a class \nis available somewhere in the classpath where it never gets loaded unless this matching is applied.").buildWithDefault(true);
    private final ConfigurationOption<List<WildcardMatcher>> classesExcludedFromInstrumentation = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("classes_excluded_from_instrumentation").configurationCategory("Core").tags("internal").description("\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("(?-i)org.infinispan*"), WildcardMatcher.valueOf("(?-i)org.apache.xerces*"), WildcardMatcher.valueOf("(?-i)org.jboss.as.*"), WildcardMatcher.valueOf("(?-i)io.undertow.core*"), WildcardMatcher.valueOf("(?-i)org.eclipse.jdt.ecj*"), WildcardMatcher.valueOf("(?-i)org.wildfly.extension.*"), WildcardMatcher.valueOf("(?-i)org.wildfly.security*")));
    private final ConfigurationOption<List<WildcardMatcher>> methodsExcludedFromInstrumentation = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("methods_excluded_from_instrumentation").configurationCategory("Core").tags("internal").description("\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("(?-i)_persistence_*")));
    private final ConfigurationOption<List<MethodMatcher>> traceMethods = ConfigurationOption.builder(MethodMatcherValueConverter.LIST, List.class).key("trace_methods").tags("added[1.3.0,Enhancements in 1.4.0, 1.7.0 and 1.9.0]").configurationCategory("Core").description("A list of methods for which to create a transaction or span.\n\nThe syntax is `modifier @fully.qualified.annotation.Name fully.qualified.class.Name#methodName(fully.qualified.parameter.Type)`.\nYou can use wildcards for the class name, the annotation name, the method name and the parameter types.\nThe `*` wildcard matches zero or more characters.\nThat means that a wildcard in a package name also matches sub-packages\nSpecifying an annotation is optional.\nWhen matching for annotations, only classes that are annotated with the specified annotation are considered.\nYou can also match for meta-annotations by specifying the annotation with an @@ prefix. This will match classes that are annotated with an annotation that is itself annotated with the given meta-annotation.\nSpecifying the parameter types is optional.\nThe `modifier` can be omitted or one of `public`, `protected`, `private` or `*`.\n\nA few examples:\n\n - `org.example.*` added[1.4.0,Omitting the method is possible since 1.4.0]\n - `org.example.*#*` (before 1.4.0, you need to specify a method matcher)\n - `org.example.MyClass#myMethod`\n - `org.example.MyClass#myMethod()`\n - `org.example.MyClass#myMethod(java.lang.String)`\n - `org.example.MyClass#myMe*od(java.lang.String, int)`\n - `private org.example.MyClass#myMe*od(java.lang.String, *)`\n - `* org.example.MyClas*#myMe*od(*.String, int[])`\n - `public org.example.services.*Service#*`\n - `public @java.inject.ApplicationScoped org.example.*`\n - `public @java.inject.* org.example.*`\n - `public @@javax.enterprise.context.NormalScope org.example.*`\n\nNOTE: Only use wildcards if necessary.\nThe more methods you match the more overhead will be caused by the agent.\nAlso note that there is a maximum amount of spans per transaction (see <<config-transaction-max-spans, `transaction_max_spans`>>).\n\nNOTE: The agent will create stack traces for spans which took longer than\n<<config-span-frames-min-duration, `span_frames_min_duration`>>.\nWhen tracing a large number of methods (for example by using wildcards),\nthis may lead to high overhead.\nConsider increasing the threshold or disabling stack trace collection altogether.\n\nCommon configurations:\n\nTrace all public methods in CDI-Annotated beans:\n\n----\npublic @@javax.enterprise.context.NormalScope your.application.package.*\npublic @@javax.inject.Scope your.application.package.*\n----\nNOTE: This method is only available in the Elastic APM Java Agent.").buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<TimeDuration> traceMethodsDurationThreshold = TimeDurationValueConverter.durationOption("ms").key("trace_methods_duration_threshold").tags("added[1.7.0]").configurationCategory("Core").description("If <<config-trace-methods, `trace_methods`>> config option is set, provides a threshold to limit spans based on \nduration. When set to a value greater than 0, spans representing methods traced based on `trace_methods` will be discarded by default.\nSuch methods will be traced and reported if one of the following applies:\n - This method's duration crossed the configured threshold.\n - This method ended with Exception.\n - A method executed as part of the execution of this method crossed the threshold or ended with Exception.\n - A \"forcibly-traced method\" (e.g. DB queries, HTTP exits, custom) was executed during the execution of this method.\nSet to 0 to disable.\n\nNOTE: Transaction are never discarded, regardless of their duration. This configuration affects only spans.\nIn order not to break span references, all spans leading to an async operations are never discarded, regardless \nof their duration.\n").buildWithDefault(TimeDuration.of("0ms"));
    private final ConfigurationOption<String> appendPackagesToBootDelagationProperty = ConfigurationOption.stringOption().key("boot_delegation_packages").tags("added[1.7.0]").configurationCategory("Core").description("A comma-separated list of packages to be appended to the boot delegation system property. \nIf set with an empty string, nothing will be appended to the boot delegation system property.\nValues to set in known environments:\n\nNexus:\n\n----\nboot_delegation_packages=com.sun.*, javax.transaction, javax.transaction.*, javax.xml.crypto, javax.xml.crypto.*, sun.*,co.elastic.apm.agent.*\n----\n\nPentaho and RedHat JBoss Fuse:\n\n----\nboot_delegation_packages=org.apache.karaf.jaas.boot, org.apache.karaf.jaas.boot.principal, org.apache.karaf.management.boot, sun.*, com.sun.*, javax.transaction, javax.transaction.*, javax.xml.crypto, javax.xml.crypto.*, org.apache.xerces.jaxp.datatype, org.apache.xerces.stax, org.apache.xerces.parsers, org.apache.xerces.jaxp, org.apache.xerces.jaxp.validation, org.apache.xerces.dom, co.elastic.apm.agent.*\n----\n").buildWithDefault("co.elastic.apm.agent.*");
    private final ConfigurationOption<Boolean> centralConfig = ConfigurationOption.booleanOption().key("central_config").tags("added[1.8.0]").configurationCategory("Core").description("When enabled, the agent will make periodic requests to the APM Server to fetch updated configuration.").dynamic(true).buildWithDefault(true);
    private final ConfigurationOption<Boolean> breakdownMetrics = ConfigurationOption.booleanOption().key("breakdown_metrics").tags("added[1.8.0]").configurationCategory("Core").description("Disables the collection of breakdown metrics (`span.self_time`)").buildWithDefault(true);
    private final ConfigurationOption<String> configFileLocation = ConfigurationOption.stringOption().key("config_file").tags("added[1.8.0]").configurationCategory("Core").description("Sets the path of the agent config file.\nThe special value `_AGENT_HOME_` is a placeholder for the folder the `elastic-apm-agent.jar` is in.\nThe file has to be on the file system.\nYou can not refer to classpath locations.\n\nNOTE: this option can only be set via system properties, environment variables or the attacher options.").buildWithDefault("_AGENT_HOME_/elasticapm.properties");

    public boolean isActive() {
        return this.active.get();
    }

    public boolean isInstrument() {
        return this.instrument.get();
    }

    public String getServiceName() {
        return this.serviceName.get();
    }

    public ConfigurationOption<String> getServiceNameConfig() {
        return this.serviceName;
    }

    @Nullable
    public String getServiceNodeName() {
        String nodeName = this.serviceNodeName.get();
        if (nodeName == null || nodeName.trim().isEmpty()) {
            return null;
        }
        return nodeName;
    }

    public String getServiceVersion() {
        return this.serviceVersion.get();
    }

    public String getHostname() {
        return this.hostname.get();
    }

    public String getEnvironment() {
        return this.environment.get();
    }

    public ConfigurationOption<Double> getSampleRate() {
        return this.sampleRate;
    }

    public int getTransactionMaxSpans() {
        return this.transactionMaxSpans.get();
    }

    public List<WildcardMatcher> getSanitizeFieldNames() {
        return this.sanitizeFieldNames.get();
    }

    public Collection<String> getDisabledInstrumentations() {
        return this.disabledInstrumentations.get();
    }

    public List<WildcardMatcher> getUnnestExceptions() {
        return this.unnestExceptions.get();
    }

    public List<WildcardMatcher> getIgnoreExceptions() {
        return this.ignoreExceptions.get();
    }

    public EventType getCaptureBody() {
        return this.captureBody.get();
    }

    public boolean isCaptureHeaders() {
        return this.captureHeaders.get();
    }

    public boolean isTypePoolCacheEnabled() {
        return this.typePoolCache.get();
    }

    public boolean isTypeMatchingWithNamePreFilter() {
        return this.typeMatchingWithNamePreFilter.get();
    }

    public boolean isClassLoadingMatchingPreFilter() {
        return this.classLoadingMatchingPreFilter.get();
    }

    public List<WildcardMatcher> getClassesExcludedFromInstrumentation() {
        return this.classesExcludedFromInstrumentation.get();
    }

    public List<WildcardMatcher> getMethodsExcludedFromInstrumentation() {
        return this.methodsExcludedFromInstrumentation.get();
    }

    public List<MethodMatcher> getTraceMethods() {
        return this.traceMethods.get();
    }

    public TimeDuration getTraceMethodsDurationThreshold() {
        return this.traceMethodsDurationThreshold.get();
    }

    @Nullable
    public String getPackagesToAppendToBootdelegationProperty() {
        String value = this.appendPackagesToBootDelagationProperty.get();
        if (value != null && (value = value.trim()).isEmpty()) {
            value = null;
        }
        return value;
    }

    public Map<String, String> getGlobalLabels() {
        return this.globalLabels.get();
    }

    boolean isCentralConfigEnabled() {
        return this.centralConfig.get();
    }

    public boolean isBreakdownMetricsEnabled() {
        return this.breakdownMetrics.get();
    }

    @Nullable
    public static String getConfigFileLocation(List<ConfigurationSource> configurationSources) {
        String configFileLocation = DEFAULT_CONFIG_FILE;
        for (ConfigurationSource configurationSource : configurationSources) {
            String valueFromSource = configurationSource.getValue(CONFIG_FILE);
            if (valueFromSource == null) continue;
            configFileLocation = valueFromSource;
            break;
        }
        if (configFileLocation.contains("_AGENT_HOME_")) {
            String agentHome = ElasticApmAgent.getAgentHome();
            if (agentHome != null) {
                return configFileLocation.replace("_AGENT_HOME_", agentHome);
            }
            return null;
        }
        return configFileLocation;
    }

    public static enum EventType {
        OFF,
        ERRORS,
        TRANSACTIONS,
        ALL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

