/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.error.logging;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractLoggingInstrumentation
extends ElasticApmInstrumentation {
    public static final ThreadLocal<Boolean> nestedThreadLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    @Override
    public Class<?> getAdviceClass() {
        return LoggingAdvice.class;
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Logger");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("error").and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.lang.String")).and(ElementMatchers.takesArgument(1, ElementMatchers.named("java.lang.Throwable"))));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("logging");
        return ret;
    }

    public static class LoggingAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void logEnter(@Advice.Argument(value=1) Throwable exception, @Advice.Local(value="nested") boolean nested) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            nested = nestedThreadLocal.get();
            if (!nested) {
                ElasticApmInstrumentation.tracer.getActive().captureException(exception);
                nestedThreadLocal.set(Boolean.TRUE);
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void logExit(@Advice.Local(value="nested") boolean nested) {
            if (!nested) {
                nestedThreadLocal.set(Boolean.FALSE);
            }
        }
    }
}

