/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.es.restclient.v6_4;

import co.elastic.apm.agent.es.restclient.ElasticsearchRestClientInstrumentation;
import co.elastic.apm.agent.es.restclient.ElasticsearchRestClientInstrumentationHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;

public class ElasticsearchClientAsyncInstrumentation
extends ElasticsearchRestClientInstrumentation {
    public ElasticsearchClientAsyncInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public Class<?> getAdviceClass() {
        return ElasticsearchRestClientAsyncAdvice.class;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.elasticsearch.client.RestClient");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("performRequestAsync").and(ElementMatchers.takesArguments(2).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.elasticsearch.client.Request"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.elasticsearch.client.ResponseListener"))));
    }

    private static class ElasticsearchRestClientAsyncAdvice {
        private ElasticsearchRestClientAsyncAdvice() {
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1, readOnly=false) ResponseListener responseListener, @Advice.Local(value="span") Span span, @Advice.Local(value="wrapped") boolean wrapped, @Advice.Local(value="helper") ElasticsearchRestClientInstrumentationHelper<HttpEntity, Response, ResponseListener> helper) {
            helper = ElasticsearchRestClientInstrumentation.esClientInstrHelperManager.getForClassLoaderOfClass(Request.class);
            if (helper != null && (span = helper.createClientSpan(request.getMethod(), request.getEndpoint(), request.getEntity())) != null) {
                responseListener = helper.wrapResponseListener(responseListener, span);
                wrapped = true;
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onAfterExecute(@Advice.Argument(value=1) ResponseListener responseListener, @Advice.Local(value="span") @Nullable Span span, @Advice.Local(value="wrapped") boolean wrapped, @Advice.Local(value="helper") @Nullable ElasticsearchRestClientInstrumentationHelper<HttpEntity, Response, ResponseListener> helper, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                span.deactivate();
                if (!wrapped) {
                    helper.finishClientSpan(null, span, t);
                }
            }
        }
    }
}

