/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class LegacyApacheHttpClientInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public Class<?> getAdviceClass() {
        return LegacyApacheHttpClientAdvice.class;
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Director");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.RequestDirector"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(3)).and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.HttpResponse")))).and(ElementMatchers.takesArgument(0, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.HttpHost")))).and(ElementMatchers.takesArgument(1, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.HttpRequest")))).and(ElementMatchers.takesArgument(2, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.protocol.HttpContext"))));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "apache-httpclient");
    }

    private static class LegacyApacheHttpClientAdvice {
        private LegacyApacheHttpClientAdvice() {
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.Argument(value=0) HttpHost host, @Advice.Argument(value=1) HttpRequest request, @Advice.Local(value="span") Span span) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            TraceContextHolder<?> parent = ElasticApmInstrumentation.tracer.getActive();
            if (request instanceof HttpUriRequest) {
                HttpUriRequest uriRequest = (HttpUriRequest)request;
                span = HttpClientHelper.startHttpClientSpan(parent, uriRequest.getMethod(), uriRequest.getURI(), host.getHostName());
                if (span != null) {
                    span.activate();
                    request.addHeader("elastic-apm-traceparent", span.getTraceContext().getOutgoingTraceParentTextHeader().toString());
                } else if (!request.containsHeader("elastic-apm-traceparent") && parent != null) {
                    request.addHeader("elastic-apm-traceparent", parent.getTraceContext().getOutgoingTraceParentTextHeader().toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Return @Nullable HttpResponse response, @Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                try {
                    if (response != null && response.getStatusLine() != null) {
                        int statusCode = response.getStatusLine().getStatusCode();
                        span.getContext().getHttp().withStatusCode(statusCode);
                    }
                    span.captureException(t);
                }
                finally {
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }
}

