/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl;

import co.elastic.apm.agent.configuration.AgentArgumentsConfigurationSource;
import co.elastic.apm.agent.configuration.ApmServerConfigurationSource;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.PrefixingConfigurationSourceWrapper;
import co.elastic.apm.agent.configuration.source.PropertyFileConfigurationSource;
import co.elastic.apm.agent.configuration.source.SystemPropertyConfigurationSource;
import co.elastic.apm.agent.context.LifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.MetaData;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.logging.LoggingConfiguration;
import co.elastic.apm.agent.objectpool.ObjectPoolFactory;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.ReporterFactory;
import co.elastic.apm.agent.report.serialize.DslJsonSerializer;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationRegistry;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.AbstractConfigurationSource;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.EnvironmentVariableConfigurationSource;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.SimpleSource;
import co.elastic.apm.agent.util.DependencyInjectingServiceLoader;
import co.elastic.apm.agent.util.ExecutorUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ElasticApmTracerBuilder {
    private static final String TEMP_PROPERTIES_FILE_KEY = "c";
    private final Logger logger;
    @Nullable
    private ConfigurationRegistry configurationRegistry;
    @Nullable
    private Reporter reporter;
    private Map<String, String> inlineConfig = new HashMap<String, String>();
    @Nullable
    private final String agentArguments;
    private ObjectPoolFactory objectPoolFactory;
    private List<LifecycleListener> extraLifecycleListeners;

    public ElasticApmTracerBuilder() {
        this(null);
    }

    public ElasticApmTracerBuilder(@Nullable String agentArguments) {
        this.agentArguments = agentArguments;
        List<ConfigurationSource> configSources = this.getConfigSources(this.agentArguments);
        LoggingConfiguration.init(configSources);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.objectPoolFactory = new ObjectPoolFactory();
        this.extraLifecycleListeners = new ArrayList<LifecycleListener>();
    }

    public ElasticApmTracerBuilder configurationRegistry(ConfigurationRegistry configurationRegistry) {
        this.configurationRegistry = configurationRegistry;
        return this;
    }

    public ElasticApmTracerBuilder reporter(Reporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public ElasticApmTracerBuilder withConfig(String key, String value) {
        this.inlineConfig.put(key, value);
        return this;
    }

    public ElasticApmTracerBuilder withObjectPoolFactory(ObjectPoolFactory objectPoolFactory) {
        this.objectPoolFactory = objectPoolFactory;
        return this;
    }

    public ElasticApmTracerBuilder withLifecycleListener(LifecycleListener listener) {
        this.extraLifecycleListeners.add(listener);
        return this;
    }

    public ElasticApmTracer build() {
        boolean addApmServerConfigSource = false;
        ArrayList<LifecycleListener> lifecycleListeners = new ArrayList<LifecycleListener>();
        if (this.configurationRegistry == null) {
            addApmServerConfigSource = true;
            List<ConfigurationSource> configSources = this.getConfigSources(this.agentArguments);
            this.configurationRegistry = this.getDefaultConfigurationRegistry(configSources);
            lifecycleListeners.add(this.scheduleReloadAtRate(this.configurationRegistry, 30, TimeUnit.SECONDS));
        }
        ApmServerClient apmServerClient = new ApmServerClient(this.configurationRegistry.getConfig(ReporterConfiguration.class));
        DslJsonSerializer payloadSerializer = new DslJsonSerializer(this.configurationRegistry.getConfig(StacktraceConfiguration.class), apmServerClient);
        MetaData metaData = MetaData.create(this.configurationRegistry, null, null);
        ApmServerConfigurationSource configurationSource = null;
        if (addApmServerConfigSource) {
            configurationSource = new ApmServerConfigurationSource(payloadSerializer, metaData, apmServerClient);
            this.configurationRegistry.addConfigurationSource(configurationSource);
            lifecycleListeners.add(configurationSource);
        }
        if (this.reporter == null) {
            this.reporter = new ReporterFactory().createReporter(this.configurationRegistry, apmServerClient, metaData);
        }
        ElasticApmTracer tracer = new ElasticApmTracer(this.configurationRegistry, this.reporter, this.objectPoolFactory);
        lifecycleListeners.addAll(DependencyInjectingServiceLoader.load(LifecycleListener.class, tracer));
        tracer.registerLifecycleListeners(lifecycleListeners);
        tracer.registerLifecycleListeners(this.extraLifecycleListeners);
        return tracer;
    }

    private LifecycleListener scheduleReloadAtRate(final ConfigurationRegistry configurationRegistry, final int rate, TimeUnit seconds) {
        final ScheduledThreadPoolExecutor configurationReloader = ExecutorUtils.createSingleThreadSchedulingDeamonPool("configuration-reloader", 1);
        configurationReloader.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ElasticApmTracerBuilder.this.logger.debug("Beginning scheduled configuration reload (interval is {} sec)...", (Object)rate);
                configurationRegistry.reloadDynamicConfigurationOptions();
                ElasticApmTracerBuilder.this.logger.debug("Finished scheduled configuration reload");
            }
        }, rate, rate, seconds);
        return LifecycleListener.ClosableAdapter.of(new Closeable(){

            @Override
            public void close() {
                configurationReloader.shutdown();
            }
        });
    }

    private ConfigurationRegistry getDefaultConfigurationRegistry(List<ConfigurationSource> configSources) {
        try {
            ConfigurationRegistry configurationRegistry = ConfigurationRegistry.builder().configSources(configSources).optionProviders(DependencyInjectingServiceLoader.load(ConfigurationOptionProvider.class, new Object[0])).failOnMissingRequiredValues(true).build();
            return configurationRegistry;
        }
        catch (IllegalStateException e) {
            this.logger.warn(e.getMessage());
            return ConfigurationRegistry.builder().addConfigSource(new SimpleSource("Noop Configuration").add("active", "false").add("instrument", "false").add("service_name", "none").add("transaction_sample_rate", "0")).optionProviders(DependencyInjectingServiceLoader.load(ConfigurationOptionProvider.class, new Object[0])).build();
        }
    }

    private List<ConfigurationSource> getConfigSources(@Nullable String agentArguments) {
        ArrayList<ConfigurationSource> result = new ArrayList<ConfigurationSource>();
        if (agentArguments != null && !agentArguments.isEmpty()) {
            AgentArgumentsConfigurationSource agentArgs = AgentArgumentsConfigurationSource.parse(agentArguments);
            result.add(agentArgs);
            ConfigurationSource attachmentConfig = this.getAttachmentArguments(agentArgs.getValue(TEMP_PROPERTIES_FILE_KEY));
            if (attachmentConfig != null) {
                result.add(attachmentConfig);
            }
        }
        result.add(new PrefixingConfigurationSourceWrapper(new SystemPropertyConfigurationSource(), "elastic.apm."));
        result.add(new PrefixingConfigurationSourceWrapper(new EnvironmentVariableConfigurationSource(), "ELASTIC_APM_"));
        result.add(new AbstractConfigurationSource(){

            @Override
            public String getValue(String key) {
                return (String)ElasticApmTracerBuilder.this.inlineConfig.get(key);
            }

            @Override
            public String getName() {
                return "Inline configuration";
            }
        });
        String configFileLocation = CoreConfiguration.getConfigFileLocation(result);
        if (configFileLocation != null && PropertyFileConfigurationSource.getFromFileSystem(configFileLocation) != null) {
            result.add(new PropertyFileConfigurationSource(configFileLocation));
        }
        if (PropertyFileConfigurationSource.isPresent("elasticapm.properties")) {
            result.add(new PropertyFileConfigurationSource("elasticapm.properties"));
        }
        return result;
    }

    @Nullable
    private ConfigurationSource getAttachmentArguments(@Nullable String configFileLocation) {
        Properties fromFileSystem;
        if (configFileLocation != null && (fromFileSystem = PropertyFileConfigurationSource.getFromFileSystem(configFileLocation)) != null) {
            SimpleSource attachmentConfig = new SimpleSource("Attachment configuration");
            for (String key : fromFileSystem.stringPropertyNames()) {
                attachmentConfig.add(key, fromFileSystem.getProperty(key));
            }
            return attachmentConfig;
        }
        return null;
    }
}

