/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.async;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.async.SpanInScopeCallableWrapper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;

abstract class SpanInScopeBaseWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SpanInScopeCallableWrapper.class);
    protected final ElasticApmTracer tracer;

    protected SpanInScopeBaseWrapper(ElasticApmTracer tracer) {
        this.tracer = tracer;
    }

    protected boolean beforeDelegation(AbstractSpan<?> localSpan) {
        boolean activated = false;
        if (localSpan != null) {
            try {
                if (this.tracer.getActive() != localSpan) {
                    localSpan.activate();
                    activated = true;
                }
            }
            catch (Throwable t) {
                try {
                    logger.error("Unexpected error while activating span", t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return activated;
    }

    protected void afterDelegation(AbstractSpan<?> localSpan, boolean activated) {
        try {
            if (localSpan != null) {
                if (activated) {
                    localSpan.deactivate();
                }
                localSpan.decrementReferences();
            }
            this.doRecycle();
        }
        catch (Throwable t) {
            try {
                logger.error("Unexpected error while deactivating or recycling span", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected abstract void doRecycle();
}

