/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.async;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.async.SpanInScopeBaseWrapper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;

public class SpanInScopeRunnableWrapper
extends SpanInScopeBaseWrapper
implements Runnable,
Recyclable {
    @Nullable
    private volatile Runnable delegate;
    @Nullable
    private volatile AbstractSpan<?> span;

    public SpanInScopeRunnableWrapper(ElasticApmTracer tracer) {
        super(tracer);
    }

    public SpanInScopeRunnableWrapper wrap(Runnable delegate, AbstractSpan<?> span) {
        this.delegate = delegate;
        this.span = span;
        span.incrementReferences();
        return this;
    }

    @Override
    public void run() {
        AbstractSpan<?> localSpan = this.span;
        boolean activated = this.beforeDelegation(localSpan);
        try {
            this.delegate.run();
        }
        finally {
            this.afterDelegation(localSpan, activated);
        }
    }

    @Override
    public void resetState() {
        this.delegate = null;
        this.span = null;
    }

    @Override
    protected void doRecycle() {
        this.tracer.recycle(this);
    }
}

