/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;

public class Destination
implements Recyclable {
    private final StringBuilder address = new StringBuilder();
    private int port;
    private final Service service = new Service();

    public Destination withAddress(@Nullable CharSequence address) {
        if (address != null && address.length() > 0) {
            int endIndex;
            int startIndex = 0;
            if (address.charAt(0) == '[') {
                startIndex = 1;
            }
            if (address.charAt((endIndex = address.length()) - 1) == ']') {
                --endIndex;
            }
            this.address.append(address, startIndex, endIndex);
        }
        return this;
    }

    public StringBuilder getAddress() {
        return this.address;
    }

    public Destination withPort(int port) {
        this.port = port;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Service getService() {
        return this.service;
    }

    public boolean hasContent() {
        return this.address.length() > 0 || this.port > 0 || this.service.hasContent();
    }

    @Override
    public void resetState() {
        this.address.setLength(0);
        this.port = -1;
        this.service.resetState();
    }

    public static class Service
    implements Recyclable {
        private final StringBuilder resource = new StringBuilder();
        private final StringBuilder name = new StringBuilder();
        @Nullable
        private String type;

        public Service withResource(String resource) {
            this.resource.append(resource);
            return this;
        }

        public StringBuilder getResource() {
            return this.resource;
        }

        public Service withName(String name) {
            this.name.append(name);
            return this;
        }

        public StringBuilder getName() {
            return this.name;
        }

        public Service withType(String type) {
            this.type = type;
            return this;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        public boolean hasContent() {
            return this.resource.length() > 0 || this.name.length() > 0 || this.type != null;
        }

        @Override
        public void resetState() {
            this.resource.setLength(0);
            this.name.setLength(0);
            this.type = null;
        }
    }
}

