/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.impl.context.Headers;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.Resetter;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.MpmcAtomicArrayQueue;
import javax.annotation.Nullable;

public class Message
implements Recyclable {
    private static final ObjectPool<StringBuilder> stringBuilderPool = QueueBasedObjectPool.of(new MpmcAtomicArrayQueue(128), false, new Allocator<StringBuilder>(){

        @Override
        public StringBuilder createInstance() {
            return new StringBuilder();
        }
    }, new Resetter<StringBuilder>(){

        @Override
        public void recycle(StringBuilder object) {
            object.setLength(0);
        }
    });
    @Nullable
    private String queueName;
    @Nullable
    private StringBuilder body;
    private long age = -1L;
    private final Headers headers = new Headers();

    @Nullable
    public String getQueueName() {
        return this.queueName;
    }

    public Message withQueue(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public StringBuilder getBodyForWrite() {
        if (this.body == null) {
            this.body = stringBuilderPool.createInstance();
        }
        return this.body;
    }

    @Nullable
    public StringBuilder getBodyForRead() {
        return this.body;
    }

    public Message withBody(@Nullable String body) {
        StringBuilder thisBody = this.getBodyForWrite();
        thisBody.setLength(0);
        thisBody.append(body);
        return this;
    }

    public Message appendToBody(CharSequence bodyContent) {
        this.getBodyForWrite().append(bodyContent);
        return this;
    }

    public void redactBody() {
        if (this.body != null && this.body.length() > 0) {
            this.body.setLength(0);
            this.body.append("[REDACTED]");
        }
    }

    public Message addHeader(String key, String value) {
        this.headers.add(key, value);
        return this;
    }

    public Message addHeader(String key, byte[] value) {
        this.headers.add(key, value);
        return this;
    }

    public long getAge() {
        return this.age;
    }

    public Message withAge(long age) {
        this.age = age;
        return this;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public boolean hasContent() {
        return this.queueName != null || this.body != null && this.body.length() > 0 || this.headers.size() > 0;
    }

    @Override
    public void resetState() {
        this.queueName = null;
        this.headers.resetState();
        this.age = -1L;
        if (this.body != null) {
            stringBuilderPool.recycle(this.body);
            this.body = null;
        }
    }

    public void copyFrom(Message other) {
        this.resetState();
        this.queueName = other.getQueueName();
        if (other.body != null) {
            this.getBodyForWrite().append((CharSequence)other.body);
        }
        this.headers.copyFrom(other.getHeaders());
        this.age = other.getAge();
    }
}

