/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public abstract class StatementInstrumentation
extends ElasticApmInstrumentation {
    @Nullable
    public static HelperClassManager<JdbcHelper> jdbcHelperManager;
    @Nullable
    public static final ConcurrentMap<String, Boolean> statementClassesNotSupportingUpdateCount;
    @Nullable
    public static final Logger logger;
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    StatementInstrumentation(ElasticApmTracer tracer, ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
        jdbcHelperManager = HelperClassManager.ForSingleClassLoader.of(tracer, "co.elastic.apm.agent.jdbc.helper.JdbcHelperImpl", "co.elastic.apm.agent.jdbc.helper.JdbcHelperImpl$1");
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Statement").or(ElementMatchers.nameStartsWith("com.ibm.db2.jcc"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("java.sql.Statement")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("jdbc");
    }

    static {
        statementClassesNotSupportingUpdateCount = new ConcurrentHashMap<String, Boolean>();
        logger = LoggerFactory.getLogger(StatementInstrumentation.class);
    }

    public static class ExecutePreparedStatementInstrumentation
    extends StatementInstrumentation {
        public ExecutePreparedStatementInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("execute").or(ElementMatchers.named("executeQuery")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement) throws SQLException {
            JdbcHelper helperImpl;
            if (tracer != null && jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                String sql = JdbcHelper.retrieveSqlForStatement(statement);
                return helperImpl.createJdbcSpan(sql, statement.getConnection(), tracer.getActive(), true);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.This Statement statement, @Advice.Enter @Nullable Span span, @Advice.Thrown Throwable t) {
            if (span != null) {
                block4: {
                    String statementClassName = statement.getClass().getName();
                    if (!statementClassesNotSupportingUpdateCount.containsKey(statementClassName)) {
                        try {
                            span.getContext().getDb().withAffectedRowsCount(statement.getUpdateCount());
                        }
                        catch (Throwable throwable) {
                            Boolean previous = statementClassesNotSupportingUpdateCount.putIfAbsent(statementClassName, Boolean.TRUE);
                            if (previous != null) break block4;
                            logger.warn("Cannot obtain update count for class {}", (Object)statementClassName);
                        }
                    }
                }
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }
    }

    public static class ExecuteUpdateNoQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteUpdateNoQueryInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("executeUpdate").or(ElementMatchers.named("executeLargeUpdate")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement) throws SQLException {
            JdbcHelper helperImpl;
            if (tracer != null && jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                String sql = JdbcHelper.retrieveSqlForStatement(statement);
                return helperImpl.createJdbcSpan(sql, statement.getConnection(), tracer.getActive(), true);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown @Nullable Throwable t, @Advice.Return long returnValue) {
            if (span != null) {
                if (t == null) {
                    span.getContext().getDb().withAffectedRowsCount(returnValue);
                }
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }
    }

    public static class ExecuteBatchInstrumentation
    extends StatementInstrumentation {
        public ExecuteBatchInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("executeBatch").or(ElementMatchers.named("executeLargeBatch")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement) throws SQLException {
            JdbcHelper helperImpl;
            if (tracer != null && jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                String sql = JdbcHelper.retrieveSqlForStatement(statement);
                return helperImpl.createJdbcSpan(sql, statement.getConnection(), tracer.getActive(), true);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown Throwable t, @Advice.Return Object returnValue) {
            if (span != null) {
                long affectedCount = 0L;
                if (returnValue instanceof int[]) {
                    int[] array = (int[])returnValue;
                    for (int i = 0; i < array.length; ++i) {
                        affectedCount += (long)array[i];
                    }
                } else if (returnValue instanceof long[]) {
                    long[] array = (long[])returnValue;
                    for (int i = 0; i < array.length; ++i) {
                        affectedCount += array[i];
                    }
                }
                span.getContext().getDb().withAffectedRowsCount(affectedCount);
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }
    }

    public static class AddBatchInstrumentation
    extends StatementInstrumentation {
        public AddBatchInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.nameStartsWith("addBatch").and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void storeSql(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) {
            JdbcHelper helperImpl;
            if (jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                JdbcHelper.mapStatementToSql(statement, sql);
            }
        }
    }

    public static class ExecuteUpdateWithQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteUpdateWithQueryInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("executeUpdate").or(ElementMatchers.named("executeLargeUpdate")).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) throws SQLException {
            JdbcHelper helperImpl;
            if (tracer != null && jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                return helperImpl.createJdbcSpan(sql, statement.getConnection(), tracer.getActive(), false);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Enter @Nullable Span span, @Advice.Thrown @Nullable Throwable t, @Advice.Return long returnValue) {
            if (span != null) {
                if (t == null) {
                    span.getContext().getDb().withAffectedRowsCount(returnValue);
                }
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }
    }

    public static class ExecuteWithQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteWithQueryInstrumentation(ElasticApmTracer tracer) {
            super(tracer, ElementMatchers.named("execute").or(ElementMatchers.named("executeQuery")).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Span onBeforeExecute(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) throws SQLException {
            JdbcHelper helperImpl;
            if (tracer != null && jdbcHelperManager != null && (helperImpl = (JdbcHelper)jdbcHelperManager.getForClassLoaderOfClass(Statement.class)) != null) {
                return helperImpl.createJdbcSpan(sql, statement.getConnection(), tracer.getActive(), false);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.This Statement statement, @Advice.Enter @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                block4: {
                    String statementClassName;
                    if (t == null && !statementClassesNotSupportingUpdateCount.containsKey(statementClassName = statement.getClass().getName())) {
                        try {
                            span.getContext().getDb().withAffectedRowsCount(statement.getUpdateCount());
                        }
                        catch (Throwable throwable) {
                            Boolean previous = statementClassesNotSupportingUpdateCount.putIfAbsent(statementClassName, Boolean.TRUE);
                            if (previous != null) break block4;
                            logger.warn("Cannot obtain update count for class {}", (Object)statementClassName);
                        }
                    }
                }
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }
    }
}

