/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.helper;

import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ConnectionMetaData {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionMetaData.class);
    private static final Map<String, ConnectionUrlParser> parsers = new HashMap<String, ConnectionUrlParser>();
    private final String dbVendor;
    @Nullable
    private final String host;
    private final int port;
    private final String user;

    public static ConnectionMetaData create(String connectionUrl, String user) {
        int indexOfNextColon;
        String dbVendor = "unknown";
        String tmpUrl = connectionUrl;
        int indexOfJdbc = tmpUrl.indexOf("jdbc:");
        if (indexOfJdbc != -1 && (indexOfNextColon = (tmpUrl = tmpUrl.substring(indexOfJdbc + 5)).indexOf(":")) != -1) {
            dbVendor = tmpUrl.substring(0, indexOfNextColon);
            tmpUrl = tmpUrl.substring(indexOfNextColon + 1);
        }
        ConnectionMetaData ret = null;
        ConnectionUrlParser connectionUrlParser = parsers.get(dbVendor);
        if (connectionUrlParser != null) {
            try {
                ret = connectionUrlParser.parse(tmpUrl, user);
            }
            catch (Exception e) {
                logger.error("Failed to parse connection URL", e);
            }
        } else {
            ret = ConnectionUrlParser.defaultParse(connectionUrl, dbVendor, -1, user);
        }
        if (ret == null) {
            ret = new ConnectionMetaData(dbVendor, null, -1, user);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Based on the connection URL {}, parsed metadata is: {}", (Object)connectionUrl, (Object)ret);
        }
        return ret;
    }

    private ConnectionMetaData(String dbVendor, @Nullable String host, int port, String user) {
        this.dbVendor = dbVendor;
        this.host = host;
        this.port = port;
        this.user = user;
    }

    public String getDbVendor() {
        return this.dbVendor;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return "ConnectionMetaData{dbVendor='" + this.dbVendor + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", user='" + this.user + '\'' + '}';
    }

    static {
        for (ConnectionUrlParser parser : ConnectionUrlParser.values()) {
            parsers.put(parser.dbVendor, parser);
        }
    }

    private static enum ConnectionUrlParser {
        ORACLE("oracle"){
            public static final int DEFAULT_PORT = 1521;

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                int indexOfUserDetailsEnd = connectionUrl.indexOf(64);
                if (indexOfUserDetailsEnd > 0) {
                    if (connectionUrl.length() > indexOfUserDetailsEnd + 1) {
                        connectionUrl = connectionUrl.substring(indexOfUserDetailsEnd + 1);
                    } else {
                        return new ConnectionMetaData(this.dbVendor, null, 1521, user);
                    }
                }
                String host = null;
                int port = 1521;
                HostPort hostPort = 1.parseHostPort(connectionUrl);
                if (hostPort.host != null) {
                    host = hostPort.host;
                    if (hostPort.port > 0) {
                        port = hostPort.port;
                    }
                } else {
                    String[] parts;
                    if (connectionUrl.startsWith("thin:")) {
                        connectionUrl = connectionUrl.substring("thin:".length());
                    }
                    if ((parts = connectionUrl.split(":")).length > 0) {
                        host = parts[0];
                    }
                    if (parts.length > 1) {
                        try {
                            port = Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                return new ConnectionMetaData(this.dbVendor, host, port, user);
            }
        }
        ,
        POSTGRESQL("postgresql"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 5432, user);
            }
        }
        ,
        MYSQL("mysql"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 3306, user);
            }
        }
        ,
        DB2("db2"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 50000, user);
            }
        }
        ,
        H2("h2"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, -1, user);
            }
        }
        ,
        DERBY("derby"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 1527, user);
            }
        }
        ,
        HSQLDB("hsqldb"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                return ConnectionUrlParser.defaultParse(connectionUrl, this.dbVendor, 9001, user);
            }
        }
        ,
        MARIADB("mariadb"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                String host = "localhost";
                int port = 3306;
                HostPort hostPort = 8.parseHostPort(connectionUrl);
                if (hostPort.host == null) {
                    hostPort = 8.parseAuthority(connectionUrl);
                }
                if (hostPort.host != null) {
                    host = hostPort.host;
                    if (hostPort.port > 0) {
                        port = hostPort.port;
                    }
                }
                return new ConnectionMetaData(this.dbVendor, host, port, user);
            }
        }
        ,
        SQLSERVER("sqlserver"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                int indexOfInstance;
                String host = "localhost";
                int port = 1433;
                int indexOfProperties = connectionUrl.indexOf(59);
                if (indexOfProperties > 0) {
                    if (connectionUrl.length() > indexOfProperties + 1) {
                        String[] properties;
                        String propertiesPart = connectionUrl.substring(indexOfProperties + 1);
                        for (String property : properties = propertiesPart.split(";")) {
                            String[] parts = property.split("=");
                            if (parts.length != 2 || !parts[0].equals("serverName")) continue;
                            host = parts[1];
                        }
                    }
                    connectionUrl = connectionUrl.substring(0, indexOfProperties);
                }
                HostPort hostPort = 9.parseHostPort(connectionUrl);
                if (hostPort.host != null) {
                    host = hostPort.host;
                    if (hostPort.port > 0) {
                        port = hostPort.port;
                    }
                }
                if ((indexOfInstance = host.indexOf(92)) > 0) {
                    host = host.substring(0, indexOfInstance);
                }
                return new ConnectionMetaData(this.dbVendor, host, port, user);
            }
        }
        ,
        UNKNOWN("unknown"){

            @Override
            ConnectionMetaData parse(String connectionUrl, String user) {
                return new ConnectionMetaData(this.dbVendor, null, -1, user);
            }
        };

        final String dbVendor;

        private ConnectionUrlParser(String dbVendor) {
            this.dbVendor = dbVendor;
        }

        abstract ConnectionMetaData parse(String var1, String var2);

        static ConnectionMetaData defaultParse(String connectionUrl, String dbVendor, int defaultPort, String user) {
            int indexOfProperties = connectionUrl.indexOf(59);
            if (indexOfProperties > 0) {
                connectionUrl = connectionUrl.substring(0, indexOfProperties);
            }
            String host = "localhost";
            int port = -1;
            HostPort hostPort = ConnectionUrlParser.parseHostPort(connectionUrl);
            if (hostPort.host != null) {
                host = hostPort.host;
                port = hostPort.port > 0 ? hostPort.port : defaultPort;
            }
            return new ConnectionMetaData(dbVendor, host, port, user);
        }

        static HostPort parseHostPort(String url) {
            int indexOfDoubleSlash;
            if (url.length() > 0 && (indexOfDoubleSlash = url.indexOf("//")) >= 0 && url.length() > indexOfDoubleSlash + 2) {
                if ((url = url.substring(indexOfDoubleSlash + 2)).length() == 1) {
                    return new HostPort("localhost", -1);
                }
                return ConnectionUrlParser.parseAuthority(url);
            }
            return new HostPort(null, -1);
        }

        static HostPort parseAuthority(String url) {
            String host;
            int lastIndexOfColon;
            int indexOfSlash;
            int indexOrProperties = url.indexOf(63);
            if (indexOrProperties > 0) {
                url = url.substring(0, indexOrProperties);
            }
            String hostPort = (indexOfSlash = url.indexOf(47)) > 0 ? url.substring(0, indexOfSlash) : url;
            int port = -1;
            int indexOfColon = hostPort.indexOf(58);
            if (indexOfColon > 0 && indexOfColon != (lastIndexOfColon = hostPort.lastIndexOf(58))) {
                int indexOfIpv6End = hostPort.indexOf(93);
                indexOfColon = indexOfIpv6End > 0 && hostPort.length() > indexOfIpv6End + 1 ? indexOfIpv6End + 1 : -1;
            }
            if (indexOfColon > 0) {
                host = hostPort.substring(0, indexOfColon);
                if (hostPort.length() > indexOfColon + 1) {
                    port = Integer.parseInt(hostPort.substring(indexOfColon + 1));
                }
            } else {
                host = hostPort;
            }
            return new HostPort(host, port);
        }

        static class HostPort {
            @Nullable
            String host;
            int port;

            public HostPort(@Nullable String host, int port) {
                this.host = host;
                this.port = port;
            }
        }
    }
}

