/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.helper;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.DataStructures;
import java.sql.Connection;
import javax.annotation.Nullable;

public abstract class JdbcHelper {
    public static final WeakConcurrentMap<Object, String> statementSqlMap = DataStructures.createWeakConcurrentMapWithCleanerThread();

    public static void mapStatementToSql(Object statement, String sql) {
        statementSqlMap.putIfAbsent(statement, sql);
    }

    @Nullable
    public static String retrieveSqlForStatement(Object statement) {
        return statementSqlMap.get(statement);
    }

    @Nullable
    public abstract Span createJdbcSpan(@Nullable String var1, Connection var2, @Nullable TraceContextHolder<?> var3, boolean var4);
}

