/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc.helper;

import co.elastic.apm.agent.impl.context.Destination;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.jdbc.helper.ConnectionMetaData;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import co.elastic.apm.agent.jdbc.signature.SignatureParser;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.DataStructures;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class JdbcHelperImpl
extends JdbcHelper {
    public static final String DB_SPAN_TYPE = "db";
    public static final String DB_SPAN_ACTION = "query";
    private static final Logger logger = LoggerFactory.getLogger(JdbcHelperImpl.class);
    private static final WeakConcurrentMap<Connection, ConnectionMetaData> metaDataMap = DataStructures.createWeakConcurrentMapWithCleanerThread();
    public static final ThreadLocal<SignatureParser> SIGNATURE_PARSER_THREAD_LOCAL = new ThreadLocal<SignatureParser>(){

        @Override
        protected SignatureParser initialValue() {
            return new SignatureParser();
        }
    };

    @Override
    @Nullable
    public Span createJdbcSpan(@Nullable String sql, Connection connection, @Nullable TraceContextHolder<?> parent, boolean preparedStatement) {
        if (sql == null || this.isAlreadyMonitored(parent) || parent == null || !parent.isSampled()) {
            return null;
        }
        Span span = (Span)parent.createSpan().activate();
        StringBuilder spanName = span.getAndOverrideName(0);
        if (spanName != null) {
            SIGNATURE_PARSER_THREAD_LOCAL.get().querySignature(sql, spanName, preparedStatement);
        }
        span.withType(DB_SPAN_TYPE);
        try {
            ConnectionMetaData connectionMetaData = this.getConnectionMetaData(connection);
            span.withSubtype(connectionMetaData.getDbVendor()).withAction(DB_SPAN_ACTION);
            span.getContext().getDb().withUser(connectionMetaData.getUser()).withStatement(sql).withType("sql");
            Destination destination = span.getContext().getDestination().withAddress(connectionMetaData.getHost()).withPort(connectionMetaData.getPort());
            destination.getService().withName(connectionMetaData.getDbVendor()).withResource(connectionMetaData.getDbVendor()).withType(DB_SPAN_TYPE);
        }
        catch (SQLException e) {
            logger.warn("Ignored exception", e);
        }
        return span;
    }

    private boolean isAlreadyMonitored(@Nullable TraceContextHolder<?> parent) {
        if (!(parent instanceof Span)) {
            return false;
        }
        Span parentSpan = (Span)parent;
        return parentSpan.getType() != null && parentSpan.getType().equals(DB_SPAN_TYPE);
    }

    private ConnectionMetaData getConnectionMetaData(Connection connection) throws SQLException {
        ConnectionMetaData connectionMetaData = metaDataMap.get(connection);
        if (connectionMetaData == null) {
            DatabaseMetaData metaData = connection.getMetaData();
            connectionMetaData = ConnectionMetaData.create(metaData.getURL(), metaData.getUserName());
            metaDataMap.put(connection, connectionMetaData);
        }
        return connectionMetaData;
    }
}

