/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jms.BaseJmsInstrumentation;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public abstract class JmsMessageConsumerInstrumentation
extends BaseJmsInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(JmsMessageConsumerInstrumentation.class);

    JmsMessageConsumerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Message").or(ElementMatchers.nameContains("Consumer")).or(ElementMatchers.nameContains("Receiver")).or(ElementMatchers.nameContains("Subscriber"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.MessageConsumer")));
    }

    public static class SetMessageListenerInstrumentation
    extends JmsMessageConsumerInstrumentation {
        public SetMessageListenerInstrumentation(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("setMessageListener").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.jms.MessageListener")));
        }

        @Override
        public Class<?> getAdviceClass() {
            return ListenerWrappingAdvice.class;
        }

        public static class ListenerWrappingAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class)
            public static void beforeSetListener(@Advice.Argument(value=0, readOnly=false) @Nullable MessageListener original) {
                JmsInstrumentationHelper<Destination, Message, MessageListener> helper = BaseJmsInstrumentation.jmsInstrHelperManager.getForClassLoaderOfClass(MessageListener.class);
                if (helper != null) {
                    original = helper.wrapLambda(original);
                }
            }
        }
    }

    public static class ReceiveInstrumentation
    extends JmsMessageConsumerInstrumentation {
        public ReceiveInstrumentation(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("receive").and(ElementMatchers.takesArguments(0).or(ElementMatchers.takesArguments(1))).and(ElementMatchers.isPublic()).or(ElementMatchers.named("receiveNoWait").and(ElementMatchers.takesArguments(0).and(ElementMatchers.isPublic())));
        }

        @Override
        public Class<?> getAdviceClass() {
            return MessageConsumerAdvice.class;
        }

        public static class MessageConsumerAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class)
            @Nullable
            public static AbstractSpan beforeReceive(@Advice.Origin Class<?> clazz, @Advice.Origin(value="#m") String methodName) {
                AbstractSpan createdSpan = null;
                boolean createPollingTransaction = false;
                boolean createPollingSpan = false;
                if (ElasticApmInstrumentation.tracer != null) {
                    TraceContextHolder<?> parent = ElasticApmInstrumentation.tracer.getActive();
                    if (parent == null) {
                        createPollingTransaction = true;
                    } else if (parent instanceof Transaction) {
                        Transaction transaction = (Transaction)parent;
                        if ("message-polling".equals(transaction.getType())) {
                            return null;
                        }
                        if ("message-handling".equals(transaction.getType())) {
                            transaction.withType("messaging");
                            ((Transaction)transaction.deactivate()).end();
                            createPollingTransaction = true;
                        } else {
                            createPollingSpan = true;
                        }
                    } else if (parent instanceof Span) {
                        Span parentSpan = (Span)parent;
                        if ("messaging".equals(parentSpan.getType()) && "receive".equals(parentSpan.getAction())) {
                            return null;
                        }
                        createPollingSpan = true;
                    }
                    if (BaseJmsInstrumentation.messagingConfiguration != null) {
                        createPollingTransaction &= BaseJmsInstrumentation.messagingConfiguration.getMessagePollingTransactionStrategy() != MessagingConfiguration.Strategy.HANDLING;
                        createPollingTransaction |= "receiveNoWait".equals(methodName);
                    }
                    if (createPollingSpan) {
                        createdSpan = parent.createSpan().withType("messaging").withSubtype("jms").withAction("receive");
                    } else if (createPollingTransaction) {
                        createdSpan = ElasticApmInstrumentation.tracer.startTransaction(TraceContext.asRoot(), null, clazz.getClassLoader()).withType("message-polling");
                    }
                    if (createdSpan != null) {
                        createdSpan.withName("JMS RECEIVE");
                        createdSpan.activate();
                    }
                }
                return createdSpan;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
            public static void afterReceive(@Advice.Origin Class<?> clazz, @Advice.Origin(value="#m") String methodName, @Advice.Enter @Nullable AbstractSpan abstractSpan, @Advice.Return @Nullable Message message, @Advice.Thrown Throwable throwable) {
                JmsInstrumentationHelper<Destination, Message, MessageListener> helper = BaseJmsInstrumentation.jmsInstrHelperManager.getForClassLoaderOfClass(MessageListener.class);
                String messageSenderContext = null;
                Destination destination = null;
                String destinationName = null;
                boolean discard = false;
                boolean addDetails = true;
                if (message != null) {
                    try {
                        messageSenderContext = message.getStringProperty(JmsInstrumentationHelper.JMS_TRACE_PARENT_PROPERTY);
                        destination = message.getJMSDestination();
                        if (helper != null) {
                            destinationName = helper.extractDestinationName(message, destination);
                            discard = helper.ignoreDestination(destinationName);
                        }
                    }
                    catch (JMSException e) {
                        logger.error("Failed to retrieve meta info from Message", e);
                    }
                    if (abstractSpan instanceof Transaction) {
                        if (discard) {
                            ((Transaction)abstractSpan).ignoreTransaction();
                        } else {
                            if (messageSenderContext != null) {
                                abstractSpan.getTraceContext().asChildOf(messageSenderContext);
                            }
                            ((Transaction)abstractSpan).withType("messaging");
                            if (helper != null) {
                                helper.addMessageDetails(message, abstractSpan);
                            }
                        }
                    }
                } else if (abstractSpan instanceof Transaction) {
                    ((Transaction)abstractSpan).ignoreTransaction();
                    addDetails = false;
                }
                if (abstractSpan != null) {
                    try {
                        if (discard) {
                            abstractSpan.setDiscard(true);
                        } else if (addDetails) {
                            if (message != null && helper != null && destinationName != null) {
                                abstractSpan.appendToName(" from ");
                                helper.addDestinationDetails(message, destination, destinationName, abstractSpan);
                                helper.setMessageAge(message, abstractSpan);
                            }
                            abstractSpan.captureException(throwable);
                        }
                    }
                    finally {
                        ((AbstractSpan)abstractSpan.deactivate()).end();
                    }
                }
                if (!discard && messageSenderContext != null && ElasticApmInstrumentation.tracer != null && ElasticApmInstrumentation.tracer.currentTransaction() == null && BaseJmsInstrumentation.messagingConfiguration != null && BaseJmsInstrumentation.messagingConfiguration.getMessagePollingTransactionStrategy() != MessagingConfiguration.Strategy.POLLING && !"receiveNoWait".equals(methodName)) {
                    Transaction messageHandlingTransaction = (Transaction)ElasticApmInstrumentation.tracer.startTransaction(TraceContext.fromTraceparentHeader(), messageSenderContext, clazz.getClassLoader()).withType("message-handling").withName("JMS RECEIVE");
                    if (helper != null && destinationName != null) {
                        messageHandlingTransaction.appendToName(" from ");
                        helper.addDestinationDetails(message, destination, destinationName, messageHandlingTransaction);
                        helper.addMessageDetails(message, messageHandlingTransaction);
                        helper.setMessageAge(message, messageHandlingTransaction);
                    }
                    messageHandlingTransaction.activate();
                }
            }
        }
    }
}

