/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jms.BaseJmsInstrumentation;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public class JmsMessageListenerInstrumentation
extends BaseJmsInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(JmsMessageListenerInstrumentation.class);

    public JmsMessageListenerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.MessageListener")).or(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.jms.listener.SessionAwareMessageListener"))));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("onMessage").and(ElementMatchers.takesArgument(0, ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.Message")))).and(ElementMatchers.isPublic());
    }

    @Override
    public Class<?> getAdviceClass() {
        return MessageListenerAdvice.class;
    }

    public static class MessageListenerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        @Nullable
        public static Transaction beforeOnMessage(@Advice.Argument(value=0) @Nullable Message message, @Advice.Origin Class<?> clazz) {
            if (message == null || ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.currentTransaction() != null) {
                return null;
            }
            Destination destination = null;
            String destinationName = null;
            long timestamp = 0L;
            try {
                destination = message.getJMSDestination();
                timestamp = message.getJMSTimestamp();
            }
            catch (JMSException e) {
                logger.warn("Failed to retrieve message's destination", e);
            }
            JmsInstrumentationHelper<Destination, Message, MessageListener> helper = BaseJmsInstrumentation.jmsInstrHelperManager.getForClassLoaderOfClass(MessageListener.class);
            if (helper != null && destination != null && helper.ignoreDestination(destinationName = helper.extractDestinationName(message, destination))) {
                return null;
            }
            Transaction transaction = null;
            try {
                String traceParentProperty = message.getStringProperty(JmsInstrumentationHelper.JMS_TRACE_PARENT_PROPERTY);
                if (traceParentProperty != null) {
                    transaction = ElasticApmInstrumentation.tracer.startTransaction(TraceContext.fromTraceparentHeader(), traceParentProperty, clazz.getClassLoader());
                }
            }
            catch (JMSException e) {
                logger.warn("Failed to retrieve trace context property from JMS message", e);
            }
            if (transaction == null) {
                transaction = ElasticApmInstrumentation.tracer.startTransaction(TraceContext.asRoot(), null, clazz.getClassLoader());
            }
            transaction.withType("messaging").withName("JMS RECEIVE");
            if (helper != null) {
                if (destinationName != null) {
                    helper.addDestinationDetails(message, destination, destinationName, (AbstractSpan)transaction.appendToName(" from "));
                }
                helper.addMessageDetails(message, transaction);
                helper.setMessageAge(message, transaction);
            }
            transaction.activate();
            return transaction;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void afterOnMessage(@Advice.Enter @Nullable Transaction transaction, @Advice.Thrown Throwable throwable) {
            if (transaction != null) {
                transaction.captureException(throwable);
                ((Transaction)transaction.deactivate()).end();
            }
        }
    }
}

