/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.jms.BaseJmsInstrumentation;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;

public abstract class JmsMessageProducerInstrumentation
extends BaseJmsInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(JmsMessageProducerInstrumentation.class);

    JmsMessageProducerInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Message").or(ElementMatchers.nameContains("Producer")).or(ElementMatchers.nameContains("Sender")).or(ElementMatchers.nameContains("Publisher"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.MessageProducer")));
    }

    public static class JmsMessageProducerWithDestinationInstrumentation
    extends JmsMessageProducerInstrumentation {
        public JmsMessageProducerWithDestinationInstrumentation(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("send").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.jms.Destination"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.jms.Message"))).and(ElementMatchers.isPublic());
        }

        @Override
        public Class<?> getAdviceClass() {
            return MessageProducerWithDestinationAdvice.class;
        }

        public static class MessageProducerWithDestinationAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class)
            @Nullable
            public static Span startSpan(@Advice.Argument(value=0) Destination destination, @Advice.Argument(value=1) Message message) {
                JmsInstrumentationHelper<Destination, Message, MessageListener> helper = BaseJmsInstrumentation.jmsInstrHelperManager.getForClassLoaderOfClass(MessageProducer.class);
                if (helper != null) {
                    return helper.startJmsSendSpan(destination, message);
                }
                return null;
            }

            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
            public static void endSpan(@Advice.Enter @Nullable Span span, @Advice.Thrown Throwable throwable) {
                if (span != null) {
                    span.captureException(throwable);
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }

    public static class JmsMessageProducerNoDestinationInstrumentation
    extends JmsMessageProducerInstrumentation {
        public JmsMessageProducerNoDestinationInstrumentation(ElasticApmTracer tracer) {
            super(tracer);
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("send").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.jms.Message"))).and(ElementMatchers.isPublic());
        }

        @Override
        public Class<?> getAdviceClass() {
            return MessageProducerNoDestinationAdvice.class;
        }

        public static class MessageProducerNoDestinationAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class)
            @Nullable
            public static Span beforeSend(@Advice.Argument(value=0) Message message, @Advice.This MessageProducer producer) {
                JmsInstrumentationHelper<Destination, Message, MessageListener> helper = BaseJmsInstrumentation.jmsInstrHelperManager.getForClassLoaderOfClass(MessageProducer.class);
                try {
                    Destination destination = producer.getDestination();
                    if (helper != null) {
                        return helper.startJmsSendSpan(destination, message);
                    }
                }
                catch (JMSException e) {
                    logger.warn("Failed to retrieve message's destination", e);
                }
                return null;
            }

            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
            public static void afterSend(@Advice.Enter @Nullable Span span, @Advice.Thrown Throwable throwable) {
                if (span != null) {
                    span.captureException(throwable);
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }
}

