/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapsTokenScanner {
    private final String input;
    private int pos;

    public MapsTokenScanner(String input) {
        this.input = input;
    }

    public static String toTokenString(List<Map<String, List<String>>> maps) {
        if (maps.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map<String, List<String>> map : maps) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                for (String value : entry.getValue()) {
                    sb.append(entry.getKey()).append('[').append(value).append(']').append(" ");
                }
            }
            if (!map.isEmpty()) {
                sb.setLength(sb.length() - 1);
            }
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public List<Map<String, String>> scanMaps() {
        this.skipWhiteSpace();
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        while (this.hasNext()) {
            maps.add(this.scanMap());
        }
        return maps;
    }

    public List<Map<String, List<String>>> scanMultiValueMaps() {
        this.skipWhiteSpace();
        ArrayList<Map<String, List<String>>> maps = new ArrayList<Map<String, List<String>>>();
        while (this.hasNext()) {
            maps.add(this.scanMultiValueMap());
        }
        return maps;
    }

    Map<String, List<String>> scanMultiValueMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.skipWhiteSpace();
        while (this.hasNext()) {
            if (this.peek() == ',') {
                this.next();
                break;
            }
            String key = this.scanKey();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(this.scanValue());
            this.skipWhiteSpace();
        }
        return map;
    }

    Map<String, String> scanMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.skipWhiteSpace();
        while (this.hasNext()) {
            if (this.peek() == ',') {
                this.next();
                break;
            }
            map.put(this.scanKey(), this.scanValue());
            this.skipWhiteSpace();
        }
        return map;
    }

    String scanKey() {
        if (this.next() == '[') {
            throw new IllegalArgumentException("Empty key at pos " + this.pos + " in '" + this.input + "'");
        }
        int start = this.pos - 1;
        while (!this.isNext('[')) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException("Expected value start token '[' at pos " + this.pos + " in '" + this.input + "'");
            }
            this.next();
        }
        return this.input.substring(start, this.pos);
    }

    String scanValue() {
        if (!this.isNext('[')) {
            throw new IllegalArgumentException("Expected value start token '[' at pos " + this.pos + " in '" + this.input + "'");
        }
        this.next();
        int start = this.pos;
        while (!this.isNext(']')) {
            if (this.isNext('[')) {
                throw new IllegalArgumentException("Invalid char '[' within a value at pos " + this.pos + " in '" + this.input + "'");
            }
            if (!this.hasNext()) {
                throw new IllegalArgumentException("Expected end value token ']' at pos " + this.pos + " in '" + this.input + "'");
            }
            this.next();
        }
        String value = this.input.substring(start, this.pos);
        this.next();
        return value;
    }

    void skipWhiteSpace() {
        while (this.hasNext() && Character.isWhitespace(this.peek())) {
            this.next();
        }
    }

    boolean isNext(char c) {
        return this.hasNext() && this.peek() == c;
    }

    char next() {
        return this.input.charAt(this.pos++);
    }

    char peek() {
        return this.input.charAt(this.pos);
    }

    boolean hasNext() {
        return this.pos < this.input.length();
    }
}

