/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.kafka.BaseKafkaHeadersInstrumentation;
import co.elastic.apm.agent.kafka.KafkaConsumerRecordsInstrumentation;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHeadersHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;

public class ConsumerRecordsRecordListInstrumentation
extends KafkaConsumerRecordsInstrumentation {
    public ConsumerRecordsRecordListInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("records").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.apache.kafka.common.TopicPartition"))).and(ElementMatchers.returns(List.class));
    }

    @Override
    public Class<?> getAdviceClass() {
        return ConsumerRecordsAdvice.class;
    }

    public static class ConsumerRecordsAdvice {
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void wrapRecordList(@Nullable @Advice.Return(readOnly=false) List<ConsumerRecord> list) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.currentTransaction() != null) {
                return;
            }
            KafkaInstrumentationHeadersHelper<ConsumerRecord, ProducerRecord, Header> kafkaInstrumentationHelper = BaseKafkaHeadersInstrumentation.kafkaInstrHeadersHelperManager.getForClassLoaderOfClass(KafkaProducer.class);
            if (list != null && kafkaInstrumentationHelper != null) {
                list = kafkaInstrumentationHelper.wrapConsumerRecordList(list);
            }
        }
    }
}

