/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.kafka.BaseKafkaHeadersInstrumentation;
import co.elastic.apm.agent.kafka.KafkaConsumerRecordsInstrumentation;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHeadersHelper;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;

public class ConsumerRecordsRecordsInstrumentation
extends KafkaConsumerRecordsInstrumentation {
    public ConsumerRecordsRecordsInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("records").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.returns(Iterable.class));
    }

    @Override
    public Class<?> getAdviceClass() {
        return ConsumerRecordsAdvice.class;
    }

    public static class ConsumerRecordsAdvice {
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void wrapIterable(@Nullable @Advice.Return(readOnly=false) Iterable<ConsumerRecord> iterable) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.currentTransaction() != null) {
                return;
            }
            KafkaInstrumentationHeadersHelper<ConsumerRecord, ProducerRecord, Header> kafkaInstrumentationHelper = BaseKafkaHeadersInstrumentation.kafkaInstrHeadersHelperManager.getForClassLoaderOfClass(KafkaProducer.class);
            if (iterable != null && kafkaInstrumentationHelper != null) {
                iterable = kafkaInstrumentationHelper.wrapConsumerRecordIterable(iterable);
            }
        }
    }
}

