/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka.helper;

import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nullable;
import org.apache.kafka.common.header.Header;

public class ElasticHeaderImpl
implements Header {
    public static final Logger logger = LoggerFactory.getLogger(ElasticHeaderImpl.class);
    private final String key;
    private final byte[] value;
    private long settingThreadId;

    public ElasticHeaderImpl(String key) {
        this.key = key;
        this.value = new byte[29];
    }

    public String key() {
        return this.key;
    }

    public byte[] valueForSetting() {
        this.settingThreadId = Thread.currentThread().getId();
        return this.value;
    }

    @Nullable
    public byte[] value() {
        if (Thread.currentThread().getId() != this.settingThreadId) {
            logger.warn("The assumption of same thread setting and serializing the header is invalid. Distributed tracing will not work");
            return null;
        }
        return this.value;
    }
}

