/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka.helper;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsIterableWrapper;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsIteratorWrapper;
import co.elastic.apm.agent.kafka.helper.ConsumerRecordsListWrapper;
import co.elastic.apm.agent.kafka.helper.ElasticHeaderImpl;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHeadersHelper;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;

public class KafkaInstrumentationHeadersHelperImpl
implements KafkaInstrumentationHeadersHelper<ConsumerRecord, ProducerRecord, Header> {
    public static final Logger logger = LoggerFactory.getLogger(KafkaInstrumentationHeadersHelperImpl.class);
    public static final ThreadLocal<ElasticHeaderImpl> traceParentHeader = new ThreadLocal();
    private final ElasticApmTracer tracer;

    public KafkaInstrumentationHeadersHelperImpl(ElasticApmTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Iterator<ConsumerRecord> wrapConsumerRecordIterator(Iterator<ConsumerRecord> consumerRecordIterator) {
        try {
            return new ConsumerRecordsIteratorWrapper(consumerRecordIterator, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords iterator", throwable);
            return consumerRecordIterator;
        }
    }

    @Override
    public Iterable<ConsumerRecord> wrapConsumerRecordIterable(Iterable<ConsumerRecord> consumerRecordIterable) {
        try {
            return new ConsumerRecordsIterableWrapper(consumerRecordIterable, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords", throwable);
            return consumerRecordIterable;
        }
    }

    @Override
    public List<ConsumerRecord> wrapConsumerRecordList(List<ConsumerRecord> consumerRecordList) {
        try {
            return new ConsumerRecordsListWrapper(consumerRecordList, this.tracer);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to wrap Kafka ConsumerRecords list", throwable);
            return consumerRecordList;
        }
    }

    @Override
    public Header getOutgoingTraceparentHeader(Span span) {
        ElasticHeaderImpl header = traceParentHeader.get();
        if (header == null) {
            header = new ElasticHeaderImpl("elasticapmtraceparent");
            traceParentHeader.set(header);
        }
        span.getTraceContext().fillOutgoingTraceParentBinaryHeader(header.valueForSetting());
        return header;
    }
}

