/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.logging;

import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JulBridgeLogger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    public static final JulBridgeLogger global = new JulBridgeLogger(LoggerFactory.getLogger("global"));
    private final Logger logger;

    JulBridgeLogger(Logger logger) {
        this.logger = logger;
    }

    public static JulBridgeLogger getGlobal() {
        return global;
    }

    public static JulBridgeLogger getLogger(String name) {
        return new JulBridgeLogger(LoggerFactory.getLogger(name));
    }

    public static JulBridgeLogger getLogger(String name, String resourceBundleName) {
        return JulBridgeLogger.getLogger(name);
    }

    public static JulBridgeLogger getAnonymousLogger() {
        return global;
    }

    public static JulBridgeLogger getAnonymousLogger(String resourceBundleName) {
        return global;
    }

    public String getName() {
        return this.logger.getName();
    }

    public void severe(String msg) {
        this.logger.error(msg);
    }

    public void warning(String msg) {
        this.logger.warn(msg);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void config(String msg) {
        this.logger.info(msg);
    }

    public void fine(String msg) {
        this.logger.debug(msg);
    }

    public void finer(String msg) {
        this.logger.debug(msg);
    }

    public void finest(String msg) {
        this.logger.trace(msg);
    }

    public void log(Level level, String msg) {
        if (level == Level.SEVERE) {
            this.logger.error(msg);
        } else if (level == Level.WARNING) {
            this.logger.warn(msg);
        } else if (level == Level.INFO) {
            this.logger.info(msg);
        } else if (level == Level.CONFIG) {
            this.logger.info(msg);
        } else if (level == Level.FINE) {
            this.logger.debug(msg);
        } else if (level == Level.FINER) {
            this.logger.debug(msg);
        } else if (level == Level.FINEST) {
            this.logger.trace(msg);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (level == Level.SEVERE) {
            this.logger.error(msg, thrown);
        } else if (level == Level.WARNING) {
            this.logger.warn(msg, thrown);
        } else if (level == Level.INFO) {
            this.logger.info(msg, thrown);
        } else if (level == Level.CONFIG) {
            this.logger.info(msg, thrown);
        } else if (level == Level.FINE) {
            this.logger.debug(msg, thrown);
        } else if (level == Level.FINER) {
            this.logger.debug(msg, thrown);
        } else if (level == Level.FINEST) {
            this.logger.trace(msg, thrown);
        }
    }

    public Level getLevel() {
        if (this.logger.isTraceEnabled()) {
            return Level.FINEST;
        }
        if (this.logger.isDebugEnabled()) {
            return Level.FINE;
        }
        if (this.logger.isInfoEnabled()) {
            return Level.INFO;
        }
        if (this.logger.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.logger.isErrorEnabled()) {
            return Level.SEVERE;
        }
        return Level.OFF;
    }

    public void setLevel(Level newLevel) throws SecurityException {
    }

    public boolean isLoggable(Level level) {
        if (level == Level.SEVERE) {
            return this.logger.isErrorEnabled();
        }
        if (level == Level.WARNING) {
            return this.logger.isWarnEnabled();
        }
        if (level == Level.INFO) {
            return this.logger.isInfoEnabled();
        }
        if (level == Level.CONFIG) {
            return this.logger.isInfoEnabled();
        }
        if (level == Level.FINE) {
            return this.logger.isDebugEnabled();
        }
        if (level == Level.FINER) {
            return this.logger.isDebugEnabled();
        }
        if (level == Level.FINEST) {
            return this.logger.isTraceEnabled();
        }
        return false;
    }

    public void log(LogRecord record) {
        this.log(record.getLevel(), record.getMessage());
    }

    public void log(Level level, String msg, Object param1) {
        this.log(level, msg);
    }

    public void log(Level level, String msg, Object[] params) {
        this.log(level, msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.log(level, msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.log(level, msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.log(level, msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.log(level, msg);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.log(level, msg);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.log(level, msg);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Object ... params) {
        this.log(level, msg);
    }

    public void logrb(Level level, ResourceBundle bundle, String msg, Object ... params) {
        this.log(level, msg);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void entering(String sourceClass, String sourceMethod) {
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
    }

    public void exiting(String sourceClass, String sourceMethod) {
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
    }

    public ResourceBundle getResourceBundle() {
        return null;
    }

    public void setResourceBundle(ResourceBundle bundle) {
    }

    public String getResourceBundleName() {
        return null;
    }

    public Filter getFilter() {
        return null;
    }

    public void setFilter(Filter newFilter) throws SecurityException {
    }

    public void addHandler(Handler handler) throws SecurityException {
    }

    public void removeHandler(Handler handler) throws SecurityException {
    }

    public Handler[] getHandlers() {
        return null;
    }

    public boolean getUseParentHandlers() {
        return false;
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
    }

    public JulBridgeLogger getParent() {
        return null;
    }

    public void setParent(JulBridgeLogger parent) {
    }
}

