/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.matcher;

import co.elastic.apm.agent.shaded.stagemonitor.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class WildcardMatcher {
    public static final String DOCUMENTATION = "This option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.";
    private static final String CASE_INSENSITIVE_PREFIX = "(?i)";
    private static final String CASE_SENSITIVE_PREFIX = "(?-i)";
    private static final String WILDCARD = "*";
    private static final WildcardMatcher MATCH_ALL = WildcardMatcher.valueOf("*");

    public static WildcardMatcher caseSensitiveMatcher(String matcher) {
        return WildcardMatcher.valueOf(CASE_SENSITIVE_PREFIX + matcher);
    }

    public static WildcardMatcher matchAll() {
        return MATCH_ALL;
    }

    public static WildcardMatcher valueOf(String wildcardString) {
        String matcher = wildcardString;
        boolean ignoreCase = true;
        if (matcher.startsWith(CASE_SENSITIVE_PREFIX)) {
            ignoreCase = false;
            matcher = matcher.substring(CASE_SENSITIVE_PREFIX.length());
        } else if (matcher.startsWith(CASE_INSENSITIVE_PREFIX)) {
            matcher = matcher.substring(CASE_INSENSITIVE_PREFIX.length());
        }
        String[] split = StringUtils.split(matcher, '*');
        if (split.length == 1) {
            return new SimpleWildcardMatcher(split[0], matcher.startsWith(WILDCARD), matcher.endsWith(WILDCARD), ignoreCase);
        }
        ArrayList<SimpleWildcardMatcher> matchers = new ArrayList<SimpleWildcardMatcher>(split.length);
        for (int i = 0; i < split.length; ++i) {
            boolean isFirst = i == 0;
            boolean isLast = i == split.length - 1;
            matchers.add(new SimpleWildcardMatcher(split[i], !isFirst || matcher.startsWith(WILDCARD), !isLast || matcher.endsWith(WILDCARD), ignoreCase));
        }
        return new CompoundWildcardMatcher(wildcardString, matcher, matchers);
    }

    @Nullable
    public static boolean isAnyMatch(List<WildcardMatcher> matchers, @Nullable String s) {
        return WildcardMatcher.anyMatch(matchers, s) != null;
    }

    @Nullable
    public static WildcardMatcher anyMatch(List<WildcardMatcher> matchers, @Nullable String s) {
        if (s == null) {
            return null;
        }
        return WildcardMatcher.anyMatch(matchers, s, null);
    }

    @Nullable
    public static WildcardMatcher anyMatch(List<WildcardMatcher> matchers, String firstPart, @Nullable String secondPart) {
        for (int i = 0; i < matchers.size(); ++i) {
            if (!matchers.get(i).matches(firstPart, secondPart)) continue;
            return matchers.get(i);
        }
        return null;
    }

    public static int indexOfIgnoreCase(String haystack1, String haystack2, String needle, boolean ignoreCase, int start, int end) {
        if (start < 0) {
            return -1;
        }
        int totalHaystackLength = haystack1.length() + haystack2.length();
        if (needle.isEmpty() || totalHaystackLength == 0) {
            return haystack1.indexOf(needle);
        }
        int haystack1Length = haystack1.length();
        int needleLength = needle.length();
        for (int i = start; i < end; ++i) {
            if (i + needleLength > totalHaystackLength) {
                return -1;
            }
            int j = 0;
            for (int ii = i; ii < totalHaystackLength && j < needleLength; ++j, ++ii) {
                char c2;
                char c = ignoreCase ? Character.toLowerCase(WildcardMatcher.charAt(ii, haystack1, haystack2, haystack1Length)) : WildcardMatcher.charAt(ii, haystack1, haystack2, haystack1Length);
                char c3 = c2 = ignoreCase ? Character.toLowerCase(needle.charAt(j)) : needle.charAt(j);
                if (c != c2) break;
            }
            if (j != needleLength) continue;
            return i;
        }
        return -1;
    }

    static char charAt(int i, String firstPart, String secondPart, int firstPartLength) {
        return i < firstPartLength ? firstPart.charAt(i) : secondPart.charAt(i - firstPartLength);
    }

    public abstract boolean matches(String var1);

    public abstract boolean matches(String var1, @Nullable String var2);

    public boolean equals(Object obj) {
        if (!(obj instanceof WildcardMatcher)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public abstract String getMatcher();

    static class SimpleWildcardMatcher
    extends WildcardMatcher {
        private final String matcher;
        private final String stringRepresentation;
        private final boolean wildcardAtEnd;
        private final boolean wildcardAtBeginning;
        private final boolean ignoreCase;

        SimpleWildcardMatcher(String matcher, boolean wildcardAtBeginning, boolean wildcardAtEnd, boolean ignoreCase) {
            this.matcher = matcher;
            this.wildcardAtEnd = wildcardAtEnd;
            this.wildcardAtBeginning = wildcardAtBeginning;
            this.ignoreCase = ignoreCase;
            this.stringRepresentation = new StringBuilder(matcher.length() + WildcardMatcher.CASE_SENSITIVE_PREFIX.length() + WildcardMatcher.WILDCARD.length() + WildcardMatcher.WILDCARD.length()).append(ignoreCase ? "" : WildcardMatcher.CASE_SENSITIVE_PREFIX).append(wildcardAtBeginning ? WildcardMatcher.WILDCARD : "").append(matcher).append(wildcardAtEnd ? WildcardMatcher.WILDCARD : "").toString();
        }

        public String toString() {
            return this.stringRepresentation;
        }

        @Override
        public boolean matches(String s) {
            return this.indexOf(s, 0) != -1;
        }

        @Override
        public boolean matches(String firstPart, @Nullable String secondPart) {
            return this.indexOf(firstPart, secondPart, 0) != -1;
        }

        int indexOf(String s, int offset) {
            return this.indexOf(s, "", offset);
        }

        int indexOf(String firstPart, @Nullable String secondPart, int offset) {
            if (secondPart == null) {
                secondPart = "";
            }
            int totalLength = firstPart.length() + secondPart.length();
            if (this.wildcardAtEnd && this.wildcardAtBeginning) {
                return SimpleWildcardMatcher.indexOfIgnoreCase(firstPart, secondPart, this.matcher, this.ignoreCase, offset, totalLength);
            }
            if (this.wildcardAtEnd) {
                return SimpleWildcardMatcher.indexOfIgnoreCase(firstPart, secondPart, this.matcher, this.ignoreCase, 0, 1);
            }
            if (this.wildcardAtBeginning) {
                return SimpleWildcardMatcher.indexOfIgnoreCase(firstPart, secondPart, this.matcher, this.ignoreCase, totalLength - this.matcher.length(), totalLength);
            }
            if (totalLength == this.matcher.length()) {
                return SimpleWildcardMatcher.indexOfIgnoreCase(firstPart, secondPart, this.matcher, this.ignoreCase, 0, totalLength);
            }
            return -1;
        }

        @Override
        public String getMatcher() {
            return this.matcher;
        }
    }

    static class CompoundWildcardMatcher
    extends WildcardMatcher {
        private final String wildcardString;
        private final String matcher;
        private final List<SimpleWildcardMatcher> wildcardMatchers;

        CompoundWildcardMatcher(String wildcardString, String matcher, List<SimpleWildcardMatcher> wildcardMatchers) {
            this.wildcardString = wildcardString;
            this.matcher = matcher;
            this.wildcardMatchers = wildcardMatchers;
        }

        @Override
        public boolean matches(String s) {
            int offset = 0;
            for (int i = 0; i < this.wildcardMatchers.size(); ++i) {
                SimpleWildcardMatcher matcher = this.wildcardMatchers.get(i);
                offset = matcher.indexOf(s, offset);
                if (offset == -1) {
                    return false;
                }
                offset += matcher.matcher.length();
            }
            return true;
        }

        @Override
        public boolean matches(String firstPart, @Nullable String secondPart) {
            int offset = 0;
            for (int i = 0; i < this.wildcardMatchers.size(); ++i) {
                SimpleWildcardMatcher matcher = this.wildcardMatchers.get(i);
                offset = matcher.indexOf(firstPart, secondPart, offset);
                if (offset == -1) {
                    return false;
                }
                offset += matcher.matcher.length();
            }
            return true;
        }

        public String toString() {
            return this.wildcardString;
        }

        @Override
        public String getMatcher() {
            return this.matcher;
        }
    }
}

