/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.async.ContextInScopeCallableWrapper;
import co.elastic.apm.agent.impl.async.ContextInScopeRunnableWrapper;
import co.elastic.apm.agent.impl.async.SpanInScopeCallableWrapper;
import co.elastic.apm.agent.impl.async.SpanInScopeRunnableWrapper;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.AtomicQueueFactory;
import co.elastic.apm.agent.shaded.jctools.queues.spec.ConcurrentQueueSpec;

public class ObjectPoolFactory {
    protected <T extends Recyclable> ObjectPool<T> createRecyclableObjectPool(int maxCapacity, Allocator<T> allocator) {
        return QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(maxCapacity)), false, allocator);
    }

    public ObjectPool<Transaction> createTransactionPool(int maxCapacity, final ElasticApmTracer tracer) {
        return this.createRecyclableObjectPool(maxCapacity, new Allocator<Transaction>(){

            @Override
            public Transaction createInstance() {
                return new Transaction(tracer);
            }
        });
    }

    public ObjectPool<Span> createSpanPool(int maxCapacity, final ElasticApmTracer tracer) {
        return this.createRecyclableObjectPool(maxCapacity, new Allocator<Span>(){

            @Override
            public Span createInstance() {
                return new Span(tracer);
            }
        });
    }

    public ObjectPool<ErrorCapture> createErrorPool(int maxCapacity, final ElasticApmTracer tracer) {
        return this.createRecyclableObjectPool(maxCapacity, new Allocator<ErrorCapture>(){

            @Override
            public ErrorCapture createInstance() {
                return new ErrorCapture(tracer);
            }
        });
    }

    public ObjectPool<SpanInScopeRunnableWrapper> createRunnableWrapperPool(int maxCapacity, final ElasticApmTracer tracer) {
        return this.createRecyclableObjectPool(maxCapacity, new Allocator<SpanInScopeRunnableWrapper>(){

            @Override
            public SpanInScopeRunnableWrapper createInstance() {
                return new SpanInScopeRunnableWrapper(tracer);
            }
        });
    }

    public ObjectPool<SpanInScopeCallableWrapper<?>> createCallableWrapperPool(int maxCapacity, final ElasticApmTracer tracer) {
        return this.createRecyclableObjectPool(maxCapacity, new Allocator<SpanInScopeCallableWrapper<?>>(){

            @Override
            public SpanInScopeCallableWrapper<?> createInstance() {
                return new SpanInScopeCallableWrapper(tracer);
            }
        });
    }

    public ObjectPool<ContextInScopeRunnableWrapper> createRunnableContextPool(int maxCapacity, final ElasticApmTracer tracer) {
        return this.createRecyclableObjectPool(maxCapacity, new Allocator<ContextInScopeRunnableWrapper>(){

            @Override
            public ContextInScopeRunnableWrapper createInstance() {
                return new ContextInScopeRunnableWrapper(tracer);
            }
        });
    }

    public ObjectPool<ContextInScopeCallableWrapper<?>> createCallableContextPool(int maxCapacity, final ElasticApmTracer tracer) {
        return this.createRecyclableObjectPool(maxCapacity, new Allocator<ContextInScopeCallableWrapper<?>>(){

            @Override
            public ContextInScopeCallableWrapper<?> createInstance() {
                return new ContextInScopeCallableWrapper(tracer);
            }
        });
    }
}

