/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool.impl;

import co.elastic.apm.agent.objectpool.ObjectPool;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class BookkeeperObjectPool<T>
implements ObjectPool<T> {
    private ObjectPool<T> pool;
    private Set<T> toReturn = Collections.newSetFromMap(new IdentityHashMap());

    public BookkeeperObjectPool(ObjectPool<T> pool) {
        this.pool = pool;
    }

    @Override
    public T createInstance() {
        T instance = this.pool.createInstance();
        this.toReturn.add(instance);
        return instance;
    }

    @Override
    public void recycle(T obj) {
        if (!this.toReturn.contains(obj)) {
            throw new IllegalStateException("trying to recycle object that has not been taken from this pool or has already been returned");
        }
        this.pool.recycle(obj);
        this.toReturn.remove(obj);
    }

    @Override
    public int getObjectsInPool() {
        return this.pool.getObjectsInPool();
    }

    @Override
    public long getGarbageCreated() {
        return this.pool.getGarbageCreated();
    }

    public Collection<T> getRecyclablesToReturn() {
        return this.toReturn;
    }

    static {
        boolean isTest = false;
        if (!$assertionsDisabled) {
            isTest = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!isTest) {
            throw new IllegalStateException("this object pool should not be used outside tests");
        }
    }
}

