/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.objectpool.impl;

import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.objectpool.Resetter;
import co.elastic.apm.agent.objectpool.impl.AbstractObjectPool;
import java.util.Queue;
import javax.annotation.Nullable;

public class QueueBasedObjectPool<T>
extends AbstractObjectPool<T> {
    private final Queue<T> queue;

    public static <T extends Recyclable> QueueBasedObjectPool<T> ofRecyclable(Queue<T> queue, boolean preAllocate, Allocator<T> allocator) {
        return new QueueBasedObjectPool<T>(queue, preAllocate, allocator, Resetter.ForRecyclable.get());
    }

    public static <T> QueueBasedObjectPool<T> of(Queue<T> queue, boolean preAllocate, Allocator<T> allocator, Resetter<T> resetter) {
        return new QueueBasedObjectPool<T>(queue, preAllocate, allocator, resetter);
    }

    private QueueBasedObjectPool(Queue<T> queue, boolean preAllocate, Allocator<T> allocator, Resetter<T> resetter) {
        super(allocator, resetter);
        this.queue = queue;
        if (preAllocate) {
            boolean addMore;
            while (addMore = queue.offer(allocator.createInstance())) {
            }
        }
    }

    @Override
    @Nullable
    public T tryCreateInstance() {
        return this.queue.poll();
    }

    @Override
    protected boolean returnToPool(T obj) {
        return this.queue.offer(obj);
    }

    @Override
    public int getObjectsInPool() {
        return this.queue.size();
    }
}

