/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.opentracing.impl;

import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.opentracing.impl.OpenTracingBridgeInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.implementation.bytecode.assign.Assigner;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;

public class ScopeManagerInstrumentation
extends OpenTracingBridgeInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    public ScopeManagerInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("co.elastic.apm.opentracing.ApmScopeManager");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class CurrentTraceContextInstrumentation
    extends ScopeManagerInstrumentation {
        public CurrentTraceContextInstrumentation() {
            super(ElementMatchers.named("getCurrentTraceContext"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void getCurrentTraceContext(@Advice.Return(readOnly=false) Object traceContext) {
            TraceContextHolder<?> active;
            if (tracer != null && (active = tracer.getActive()) instanceof TraceContext) {
                traceContext = active;
            }
        }
    }

    public static class CurrentSpanInstrumentation
    extends ScopeManagerInstrumentation {
        public CurrentSpanInstrumentation() {
            super(ElementMatchers.named("getCurrentSpan"));
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void getCurrentSpan(@Advice.Return(readOnly=false) Object span) {
            TraceContextHolder<?> active;
            if (tracer != null && (active = tracer.getActive()) instanceof AbstractSpan) {
                span = active;
            }
        }
    }

    public static class ActivateInstrumentation
    extends ScopeManagerInstrumentation {
        public ActivateInstrumentation() {
            super(ElementMatchers.named("doActivate"));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void doActivate(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) @Nullable AbstractSpan<?> span, @Advice.Argument(value=1, typing=Assigner.Typing.DYNAMIC) @Nullable TraceContext traceContext) {
            if (span != null) {
                span.activate();
            } else if (traceContext != null && tracer != null) {
                tracer.activate(traceContext);
            }
        }
    }
}

