/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.plugin.api;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.AnnotationValueOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class TracedInstrumentation
extends ElasticApmInstrumentation {
    private final StacktraceConfiguration config;

    public TracedInstrumentation(ElasticApmTracer tracer) {
        this.config = tracer.getConfig(StacktraceConfiguration.class);
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onMethodEnter(@Advice.Origin Class<?> clazz, @SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.Traced", method="value") String spanName, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.Traced", method="type") String type, @Nullable @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.Traced", method="subtype") String subtype, @Nullable @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.Traced", method="action") String action, @Advice.Local(value="span") AbstractSpan abstractSpan) {
        if (tracer != null) {
            TraceContextHolder<?> parent = tracer.getActive();
            if (parent != null) {
                Span span = parent.createSpan();
                span.withType(type.isEmpty() ? "app" : type);
                span.withSubtype(subtype);
                span.withAction(action);
                ((Span)span.withName(spanName.isEmpty() ? signature : spanName)).activate();
                abstractSpan = span;
            } else {
                Transaction transaction = tracer.startTransaction(TraceContext.asRoot(), null, clazz.getClassLoader());
                if (spanName.isEmpty()) {
                    transaction.withName(signature, 100);
                } else {
                    transaction.withName(spanName, 1000);
                }
                transaction.withType(type.isEmpty() ? "request" : type).activate();
                abstractSpan = transaction;
            }
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onMethodExit(@Nullable @Advice.Local(value="span") AbstractSpan span, @Advice.Thrown Throwable t) {
        if (span != null) {
            ((TraceContextHolder)span.captureException(t)).deactivate();
            span.end();
        }
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("co.elastic.apm.api.Traced");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.config.getApplicationPackages(), ElementMatchers.none()).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.Traced"));
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return false;
    }

    @Override
    public final Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("public-api", "annotations");
    }
}

