/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.process;

import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;

public class ProcessHelper {
    private static final ProcessHelper INSTANCE = new ProcessHelper(new WeakConcurrentMap.WithInlinedExpunction<Process, Span>());
    private final WeakConcurrentMap<Process, Span> inFlightSpans;

    ProcessHelper(WeakConcurrentMap<Process, Span> inFlightSpans) {
        this.inFlightSpans = inFlightSpans;
    }

    public static void startProcess(TraceContextHolder<?> parentContext, Process process, List<String> command) {
        INSTANCE.doStartProcess(parentContext, process, command.get(0));
    }

    public static void endProcess(@Nonnull Process process, boolean checkTerminatedProcess) {
        INSTANCE.doEndProcess(process, checkTerminatedProcess);
    }

    void doStartProcess(@Nonnull TraceContextHolder<?> parentContext, @Nonnull Process process, @Nonnull String processName) {
        if (this.inFlightSpans.containsKey(process)) {
            return;
        }
        String binaryName = ProcessHelper.getBinaryName(processName);
        Span span = (Span)parentContext.createSpan().withType("process").withSubtype(binaryName).withAction("execute").withName(binaryName);
        this.inFlightSpans.put(process, span);
    }

    private static String getBinaryName(String processName) {
        int lastSeparator = processName.lastIndexOf(File.separatorChar);
        return lastSeparator < 0 ? processName : processName.substring(lastSeparator + 1);
    }

    void doEndProcess(Process process, boolean checkTerminatedProcess) {
        Span span;
        boolean terminated;
        boolean bl = terminated = !checkTerminatedProcess;
        if (checkTerminatedProcess) {
            try {
                process.exitValue();
                terminated = true;
            }
            catch (IllegalThreadStateException e) {
                terminated = false;
            }
        }
        if (terminated && (span = this.inFlightSpans.remove(process)) != null) {
            span.end();
        }
    }
}

