/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.quartz.job;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.TraceContextHolder;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.quartz.job.JobTransactionNameInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import javax.annotation.Nullable;
import org.quartz.JobExecutionContext;

public class JobTransactionNameAdvice {
    public static final Logger logger = LoggerFactory.getLogger(JobTransactionNameInstrumentation.class);

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void setTransactionName(@Advice.Argument(value=0) @Nullable JobExecutionContext context, @SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @Advice.Origin Class<?> clazz, @Advice.Local(value="transaction") Transaction transaction) {
        if (ElasticApmInstrumentation.tracer != null) {
            TraceContextHolder<?> active = ElasticApmInstrumentation.tracer.getActive();
            if (context == null) {
                logger.warn("Cannot correctly name transaction for method {} because JobExecutionContext is null", (Object)signature);
                transaction = (Transaction)((Transaction)ElasticApmInstrumentation.tracer.startTransaction(TraceContext.asRoot(), null, clazz.getClassLoader()).withName(signature)).withType("scheduled").activate();
            } else if (active == null) {
                transaction = (Transaction)((Transaction)ElasticApmInstrumentation.tracer.startTransaction(TraceContext.asRoot(), null, clazz.getClassLoader()).withName(context.getJobDetail().getKey().toString())).withType("scheduled").activate();
            } else {
                logger.debug("Not creating transaction for method {} because there is already a transaction running ({})", (Object)signature, (Object)active);
            }
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onMethodExitException(@Advice.Argument(value=0) @Nullable JobExecutionContext context, @Advice.Local(value="transaction") @Nullable Transaction transaction, @Advice.Thrown Throwable t) {
        if (transaction != null) {
            if (context != null && context.getResult() != null) {
                transaction.withResultIfUnset(context.getResult().toString());
            }
            ((Transaction)((Transaction)transaction.captureException(t)).deactivate()).end();
        }
    }
}

