/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.redis.lettuce;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import io.lettuce.core.protocol.RedisCommand;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public class Lettuce5StartSpanInstrumentation
extends ElasticApmInstrumentation {
    public static final WeakConcurrentMap<RedisCommand, Span> commandToSpan = new WeakConcurrentMap.WithInlinedExpunction<RedisCommand, Span>();

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.lettuce.core.RedisChannelHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("dispatch").and(ElementMatchers.returns(ElementMatchers.nameEndsWith("RedisCommand"))).and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.nameEndsWith("RedisCommand")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "lettuce");
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    private static void beforeDispatch(@Nullable @Advice.Argument(value=0) RedisCommand command, @Advice.Local(value="span") Span span) throws Exception {
        if (command != null && (span = RedisSpanUtils.createRedisSpan(command.getType().name())) != null) {
            commandToSpan.put(command, span);
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class)
    private static void afterDispatch(@Nullable @Advice.Local(value="span") Span span) {
        if (span != null) {
            span.deactivate();
        }
    }
}

