/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;

public class RequestStreamRecordingInstrumentation
extends ElasticApmInstrumentation {
    @Nullable
    public static HelperClassManager<InputStreamWrapperFactory> wrapperHelperClassManager;

    public RequestStreamRecordingInstrumentation(ElasticApmTracer tracer) {
        wrapperHelperClassManager = HelperClassManager.ForSingleClassLoader.of(tracer, "co.elastic.apm.agent.servlet.helper.InputStreamFactoryHelperImpl", "co.elastic.apm.agent.servlet.helper.RecordingServletInputStreamWrapper");
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Request");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("javax.servlet.ServletRequest")).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("getInputStream").and(ElementMatchers.returns(ElementMatchers.named("javax.servlet.ServletInputStream")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("servlet-api", "servlet-input-stream");
    }

    @Override
    public Class<?> getAdviceClass() {
        return GetInputStreamAdvice.class;
    }

    public static class GetInputStreamAdvice {
        public static final ThreadLocal<Boolean> nestedThreadLocal = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };

        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onReadEnter(@Advice.This Object thiz, @Advice.Local(value="transaction") Transaction transaction, @Advice.Local(value="nested") boolean nested) {
            nested = nestedThreadLocal.get();
            nestedThreadLocal.set(Boolean.TRUE);
        }

        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void afterGetInputStream(@Advice.Return(readOnly=false) ServletInputStream inputStream, @Advice.Local(value="nested") boolean nested) {
            if (nested || ElasticApmInstrumentation.tracer == null || wrapperHelperClassManager == null) {
                return;
            }
            try {
                Transaction transaction = ElasticApmInstrumentation.tracer.currentTransaction();
                if (transaction != null && transaction.getContext().getRequest().getBodyBuffer() != null) {
                    inputStream = wrapperHelperClassManager.getForClassLoaderOfClass(inputStream.getClass()).wrap(transaction.getContext().getRequest(), inputStream);
                }
            }
            finally {
                nestedThreadLocal.set(Boolean.FALSE);
            }
        }
    }

    public static interface InputStreamWrapperFactory {
        public ServletInputStream wrap(Request var1, ServletInputStream var2);
    }
}

