/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.bytebuddy.utility;

import co.elastic.apm.agent.shaded.bytebuddy.build.HashCodeAndEqualsPlugin;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.PackageDescription;
import co.elastic.apm.agent.shaded.bytebuddy.utility.JavaType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModule
implements NamedElement.WithOptionalName {
    public static final JavaModule UNSUPPORTED = null;
    private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
    private final Object module;

    protected JavaModule(Object module) {
        this.module = module;
    }

    public static JavaModule ofType(Class<?> type) {
        return DISPATCHER.moduleOf(type);
    }

    public static JavaModule of(Object module) {
        if (!JavaType.MODULE.isInstance(module)) {
            throw new IllegalArgumentException("Not a Java module: " + module);
        }
        return new JavaModule(module);
    }

    public static boolean isSupported() {
        return DISPATCHER.isAlive();
    }

    @Override
    public boolean isNamed() {
        return DISPATCHER.isNamed(this.module);
    }

    @Override
    public String getActualName() {
        return DISPATCHER.getName(this.module);
    }

    public InputStream getResourceAsStream(String name) {
        return DISPATCHER.getResourceAsStream(this.module, name);
    }

    public ClassLoader getClassLoader() {
        return DISPATCHER.getClassLoader(this.module);
    }

    public Object unwrap() {
        return this.module;
    }

    public boolean canRead(JavaModule module) {
        return DISPATCHER.canRead(this.module, module.unwrap());
    }

    public boolean isExported(PackageDescription packageDescription, JavaModule module) {
        return packageDescription == null || DISPATCHER.isExported(this.module, module.unwrap(), packageDescription.getName());
    }

    public boolean isOpened(PackageDescription packageDescription, JavaModule module) {
        return packageDescription == null || DISPATCHER.isOpened(this.module, module.unwrap(), packageDescription.getName());
    }

    public void modify(Instrumentation instrumentation, Set<JavaModule> reads, Map<String, Set<JavaModule>> exports, Map<String, Set<JavaModule>> opens, Set<Class<?>> uses, Map<Class<?>, List<Class<?>>> provides) {
        HashSet<Object> unwrappedReads = new HashSet<Object>();
        for (JavaModule javaModule : reads) {
            unwrappedReads.add(javaModule.unwrap());
        }
        HashMap<String, Set<Object>> unwrappedExports = new HashMap<String, Set<Object>>();
        for (Map.Entry<String, Set<JavaModule>> entry : exports.entrySet()) {
            HashSet<Object> modules = new HashSet<Object>();
            for (JavaModule module : entry.getValue()) {
                modules.add(module.unwrap());
            }
            unwrappedExports.put(entry.getKey(), modules);
        }
        HashMap<String, Set<Object>> hashMap = new HashMap<String, Set<Object>>();
        for (Map.Entry<String, Set<JavaModule>> entry : opens.entrySet()) {
            HashSet<Object> modules = new HashSet<Object>();
            for (JavaModule module : entry.getValue()) {
                modules.add(module.unwrap());
            }
            hashMap.put(entry.getKey(), modules);
        }
        DISPATCHER.modify(instrumentation, this.module, unwrappedReads, unwrappedExports, hashMap, uses, provides);
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaModule)) {
            return false;
        }
        JavaModule javaModule = (JavaModule)other;
        return this.module.equals(javaModule.module);
    }

    public String toString() {
        return this.module.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Dispatcher {
        public boolean isAlive();

        public JavaModule moduleOf(Class<?> var1);

        public boolean isNamed(Object var1);

        public String getName(Object var1);

        public InputStream getResourceAsStream(Object var1, String var2);

        public ClassLoader getClassLoader(Object var1);

        public boolean isExported(Object var1, Object var2, String var3);

        public boolean isOpened(Object var1, Object var2, String var3);

        public boolean canRead(Object var1, Object var2);

        public void modify(Instrumentation var1, Object var2, Set<Object> var3, Map<String, Set<Object>> var4, Map<String, Set<Object>> var5, Set<Class<?>> var6, Map<Class<?>, List<Class<?>>> var7);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Disabled implements Dispatcher
        {
            INSTANCE;


            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public JavaModule moduleOf(Class<?> type) {
                return UNSUPPORTED;
            }

            @Override
            public ClassLoader getClassLoader(Object module) {
                throw new UnsupportedOperationException("Current VM does not support modules");
            }

            @Override
            public boolean isNamed(Object module) {
                throw new UnsupportedOperationException("Current VM does not support modules");
            }

            @Override
            public String getName(Object module) {
                throw new UnsupportedOperationException("Current VM does not support modules");
            }

            @Override
            public InputStream getResourceAsStream(Object module, String name) {
                throw new UnsupportedOperationException("Current VM does not support modules");
            }

            @Override
            public boolean isExported(Object source, Object target, String aPackage) {
                throw new UnsupportedOperationException("Current VM does not support modules");
            }

            @Override
            public boolean isOpened(Object source, Object target, String aPackage) {
                throw new UnsupportedOperationException("Current VM does not support modules");
            }

            @Override
            public boolean canRead(Object source, Object target) {
                throw new UnsupportedOperationException("Current VM does not support modules");
            }

            @Override
            public void modify(Instrumentation instrumentation, Object module, Set<Object> reads, Map<String, Set<Object>> exports, Map<String, Set<Object>> opens, Set<Class<?>> uses, Map<Class<?>, List<Class<?>>> provides) {
                throw new UnsupportedOperationException("Current VM does not support modules");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Enabled
        implements Dispatcher {
            private static final Object[] NO_ARGUMENTS = new Object[0];
            private final Method getModule;
            private final Method getClassLoader;
            private final Method isNamed;
            private final Method getName;
            private final Method getResourceAsStream;
            private final Method isExported;
            private final Method isOpened;
            private final Method canRead;
            private final Method isModifiableModule;
            private final Method redefineModule;

            protected Enabled(Method getModule, Method getClassLoader, Method isNamed, Method getName, Method getResourceAsStream, Method isExported, Method isOpened, Method canRead, Method isModifiableModule, Method redefineModule) {
                this.getModule = getModule;
                this.getClassLoader = getClassLoader;
                this.isNamed = isNamed;
                this.getName = getName;
                this.getResourceAsStream = getResourceAsStream;
                this.isExported = isExported;
                this.isOpened = isOpened;
                this.canRead = canRead;
                this.isModifiableModule = isModifiableModule;
                this.redefineModule = redefineModule;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public JavaModule moduleOf(Class<?> type) {
                try {
                    return new JavaModule(this.getModule.invoke(type, NO_ARGUMENTS));
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getModule, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getModule, exception.getCause());
                }
            }

            @Override
            public InputStream getResourceAsStream(Object module, String name) {
                try {
                    return (InputStream)this.getResourceAsStream.invoke(module, name);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getResourceAsStream, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getResourceAsStream, exception.getCause());
                }
            }

            @Override
            public ClassLoader getClassLoader(Object module) {
                try {
                    return (ClassLoader)this.getClassLoader.invoke(module, NO_ARGUMENTS);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getClassLoader, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getClassLoader, exception.getCause());
                }
            }

            @Override
            public boolean isNamed(Object module) {
                try {
                    return (Boolean)this.isNamed.invoke(module, NO_ARGUMENTS);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.isNamed, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.isNamed, exception.getCause());
                }
            }

            @Override
            public String getName(Object module) {
                try {
                    return (String)this.getName.invoke(module, NO_ARGUMENTS);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getName, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getName, exception.getCause());
                }
            }

            @Override
            public boolean isExported(Object source, Object target, String aPackage) {
                try {
                    return (Boolean)this.isExported.invoke(source, aPackage, target);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.isExported, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.isExported, exception.getCause());
                }
            }

            @Override
            public boolean isOpened(Object source, Object target, String aPackage) {
                try {
                    return (Boolean)this.isOpened.invoke(source, aPackage, target);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.isOpened, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.isOpened, exception.getCause());
                }
            }

            @Override
            public boolean canRead(Object source, Object target) {
                try {
                    return (Boolean)this.canRead.invoke(source, target);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.canRead, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.canRead, exception.getCause());
                }
            }

            @Override
            public void modify(Instrumentation instrumentation, Object source, Set<Object> reads, Map<String, Set<Object>> exports, Map<String, Set<Object>> opens, Set<Class<?>> uses, Map<Class<?>, List<Class<?>>> provides) {
                try {
                    if (!((Boolean)this.isModifiableModule.invoke((Object)instrumentation, source)).booleanValue()) {
                        throw new IllegalStateException(source + " is not modifiable");
                    }
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.redefineModule, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.redefineModule, exception.getCause());
                }
                try {
                    this.redefineModule.invoke((Object)instrumentation, source, reads, exports, opens, uses, provides);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.redefineModule, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.redefineModule, exception.getCause());
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.getModule.equals(((Enabled)object).getModule)) {
                    return false;
                }
                if (!this.getClassLoader.equals(((Enabled)object).getClassLoader)) {
                    return false;
                }
                if (!this.isNamed.equals(((Enabled)object).isNamed)) {
                    return false;
                }
                if (!this.getName.equals(((Enabled)object).getName)) {
                    return false;
                }
                if (!this.getResourceAsStream.equals(((Enabled)object).getResourceAsStream)) {
                    return false;
                }
                if (!this.isExported.equals(((Enabled)object).isExported)) {
                    return false;
                }
                if (!this.isOpened.equals(((Enabled)object).isOpened)) {
                    return false;
                }
                if (!this.canRead.equals(((Enabled)object).canRead)) {
                    return false;
                }
                if (!this.isModifiableModule.equals(((Enabled)object).isModifiableModule)) {
                    return false;
                }
                return this.redefineModule.equals(((Enabled)object).redefineModule);
            }

            public int hashCode() {
                return (((((((((17 * 31 + this.getModule.hashCode()) * 31 + this.getClassLoader.hashCode()) * 31 + this.isNamed.hashCode()) * 31 + this.getName.hashCode()) * 31 + this.getResourceAsStream.hashCode()) * 31 + this.isExported.hashCode()) * 31 + this.isOpened.hashCode()) * 31 + this.canRead.hashCode()) * 31 + this.isModifiableModule.hashCode()) * 31 + this.redefineModule.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CreationAction implements PrivilegedAction<Dispatcher>
        {
            INSTANCE;


            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
            public Dispatcher run() {
                try {
                    Class<?> module = Class.forName("java.lang.Module");
                    return new Enabled(Class.class.getMethod("getModule", new Class[0]), module.getMethod("getClassLoader", new Class[0]), module.getMethod("isNamed", new Class[0]), module.getMethod("getName", new Class[0]), module.getMethod("getResourceAsStream", String.class), module.getMethod("isExported", String.class, module), module.getMethod("isOpen", String.class, module), module.getMethod("canRead", module), Instrumentation.class.getMethod("isModifiableModule", module), Instrumentation.class.getMethod("redefineModule", module, Set.class, Map.class, Map.class, Set.class, Map.class));
                }
                catch (Exception ignored) {
                    return Disabled.INSTANCE;
                }
            }
        }
    }
}

