/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.dslplatform.json;

abstract class Grisu3 {
    static final int kFastDtoaMaximalLength = 17;
    static final int minimal_target_exponent = -60;

    Grisu3() {
    }

    public static boolean tryConvert(double value, FastDtoaBuilder buffer) {
        int firstDigit;
        long bits;
        buffer.reset();
        if (value < 0.0) {
            buffer.append((byte)45);
            bits = Double.doubleToLongBits(-value);
            firstDigit = 1;
        } else {
            bits = Double.doubleToLongBits(value);
            firstDigit = 0;
        }
        int mk = buffer.initialize(bits);
        if (FastDtoa.digitGen(buffer, mk)) {
            buffer.write(firstDigit);
            return true;
        }
        return false;
    }

    static class FastDtoaBuilder {
        private final DiyFp v = new DiyFp();
        private final DiyFp w = new DiyFp();
        private final DiyFp boundary_minus = new DiyFp();
        private final DiyFp boundary_plus = new DiyFp();
        private final DiyFp ten_mk = new DiyFp();
        private final DiyFp scaled_w = new DiyFp();
        private final DiyFp scaled_boundary_minus = new DiyFp();
        private final DiyFp scaled_boundary_plus = new DiyFp();
        private final DiyFp too_low = new DiyFp();
        private final DiyFp too_high = new DiyFp();
        private final DiyFp unsafe_interval = new DiyFp();
        private final DiyFp one = new DiyFp();
        private final DiyFp minus_round = new DiyFp();
        private final byte[] chars = new byte[27];
        private int end = 0;
        private int point;
        static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

        FastDtoaBuilder() {
        }

        int initialize(long bits) {
            DoubleHelper.asNormalizedDiyFp(bits, this.w);
            this.boundary_minus.reset();
            this.boundary_plus.reset();
            DoubleHelper.normalizedBoundaries(this.v, bits, this.boundary_minus, this.boundary_plus);
            this.ten_mk.reset();
            int mk = CachedPowers.getCachedPower(this.w.e + 64, -60, this.ten_mk);
            this.scaled_w.f = this.w.f;
            this.scaled_w.e = this.w.e;
            this.scaled_w.multiply(this.ten_mk);
            this.scaled_boundary_minus.f = this.boundary_minus.f;
            this.scaled_boundary_minus.e = this.boundary_minus.e;
            this.scaled_boundary_minus.multiply(this.ten_mk);
            this.scaled_boundary_plus.f = this.boundary_plus.f;
            this.scaled_boundary_plus.e = this.boundary_plus.e;
            this.scaled_boundary_plus.multiply(this.ten_mk);
            return mk;
        }

        void reset() {
            this.end = 0;
        }

        void append(byte c) {
            this.chars[this.end++] = c;
        }

        void decreaseLast() {
            int n = this.end - 1;
            this.chars[n] = (byte)(this.chars[n] - 1);
        }

        public String toString() {
            return "[chars:" + new String(this.chars, 0, this.end) + ", point:" + this.point + "]";
        }

        int copyTo(byte[] target, int position) {
            for (int i = 0; i < this.end; ++i) {
                target[i + position] = this.chars[i];
            }
            return this.end;
        }

        public void write(int firstDigit) {
            int decPoint = this.point - firstDigit;
            if (decPoint < -5 || decPoint > 21) {
                this.toExponentialFormat(firstDigit, decPoint);
            } else {
                this.toFixedFormat(firstDigit, decPoint);
            }
        }

        private void toFixedFormat(int firstDigit, int decPoint) {
            if (this.point < this.end) {
                if (decPoint > 0) {
                    for (int i = this.end; i >= this.point; --i) {
                        this.chars[i + 1] = this.chars[i];
                    }
                    this.chars[this.point] = 46;
                    ++this.end;
                } else {
                    int offset = 2 - decPoint;
                    for (int i = this.end + firstDigit; i >= firstDigit; --i) {
                        this.chars[i + offset] = this.chars[i];
                    }
                    this.chars[firstDigit] = 48;
                    this.chars[firstDigit + 1] = 46;
                    if (decPoint < 0) {
                        int target = firstDigit + 2 - decPoint;
                        for (int i = firstDigit + 2; i < target; ++i) {
                            this.chars[i] = 48;
                        }
                    }
                    this.end += 2 - decPoint;
                }
            } else if (this.point > this.end) {
                for (int i = this.end; i < this.point; ++i) {
                    this.chars[i] = 48;
                }
                this.end += this.point - this.end;
                this.chars[this.end] = 46;
                this.chars[this.end + 1] = 48;
                this.end += 2;
            } else {
                this.chars[this.end] = 46;
                this.chars[this.end + 1] = 48;
                this.end += 2;
            }
        }

        private void toExponentialFormat(int firstDigit, int decPoint) {
            if (this.end - firstDigit > 1) {
                int dot = firstDigit + 1;
                System.arraycopy(this.chars, dot, this.chars, dot + 1, this.end - dot);
                this.chars[dot] = 46;
                ++this.end;
            }
            this.chars[this.end++] = 69;
            int sign = 43;
            int exp = decPoint - 1;
            if (exp < 0) {
                sign = 45;
                exp = -exp;
            }
            this.chars[this.end++] = sign;
            int charPos = exp > 99 ? this.end + 2 : (exp > 9 ? this.end + 1 : this.end);
            this.end = charPos + 1;
            do {
                int r = exp % 10;
                this.chars[charPos--] = digits[r];
            } while ((exp /= 10) != 0);
        }
    }

    static class FastDtoa {
        static final int kTen4 = 10000;
        static final int kTen5 = 100000;
        static final int kTen6 = 1000000;
        static final int kTen7 = 10000000;
        static final int kTen8 = 100000000;
        static final int kTen9 = 1000000000;

        FastDtoa() {
        }

        static boolean roundWeed(FastDtoaBuilder buffer, long distance_too_high_w, long unsafe_interval, long rest, long ten_kappa, long unit) {
            long small_distance = distance_too_high_w - unit;
            long big_distance = distance_too_high_w + unit;
            while (rest < small_distance && unsafe_interval - rest >= ten_kappa && (rest + ten_kappa < small_distance || small_distance - rest >= rest + ten_kappa - small_distance)) {
                buffer.decreaseLast();
                rest += ten_kappa;
            }
            if (rest < big_distance && unsafe_interval - rest >= ten_kappa && (rest + ten_kappa < big_distance || big_distance - rest > rest + ten_kappa - big_distance)) {
                return false;
            }
            return 2L * unit <= rest && rest <= unsafe_interval - 4L * unit;
        }

        static long biggestPowerTen(int number, int number_bits) {
            int exponent;
            int power;
            switch (number_bits) {
                case 30: 
                case 31: 
                case 32: {
                    if (1000000000 <= number) {
                        power = 1000000000;
                        exponent = 9;
                        break;
                    }
                }
                case 27: 
                case 28: 
                case 29: {
                    if (100000000 <= number) {
                        power = 100000000;
                        exponent = 8;
                        break;
                    }
                }
                case 24: 
                case 25: 
                case 26: {
                    if (10000000 <= number) {
                        power = 10000000;
                        exponent = 7;
                        break;
                    }
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    if (1000000 <= number) {
                        power = 1000000;
                        exponent = 6;
                        break;
                    }
                }
                case 17: 
                case 18: 
                case 19: {
                    if (100000 <= number) {
                        power = 100000;
                        exponent = 5;
                        break;
                    }
                }
                case 14: 
                case 15: 
                case 16: {
                    if (10000 <= number) {
                        power = 10000;
                        exponent = 4;
                        break;
                    }
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (1000 <= number) {
                        power = 1000;
                        exponent = 3;
                        break;
                    }
                }
                case 7: 
                case 8: 
                case 9: {
                    if (100 <= number) {
                        power = 100;
                        exponent = 2;
                        break;
                    }
                }
                case 4: 
                case 5: 
                case 6: {
                    if (10 <= number) {
                        power = 10;
                        exponent = 1;
                        break;
                    }
                }
                case 1: 
                case 2: 
                case 3: {
                    if (1 <= number) {
                        power = 1;
                        exponent = 0;
                        break;
                    }
                }
                case 0: {
                    power = 0;
                    exponent = -1;
                    break;
                }
                default: {
                    power = 0;
                    exponent = 0;
                }
            }
            return (long)power << 32 | 0xFFFFFFFFL & (long)exponent;
        }

        static boolean digitGen(FastDtoaBuilder buffer, int mk) {
            int digit;
            DiyFp low = buffer.scaled_boundary_minus;
            DiyFp w = buffer.scaled_w;
            DiyFp high = buffer.scaled_boundary_plus;
            long unit = 1L;
            DiyFp too_low = buffer.too_low;
            too_low.f = low.f - unit;
            too_low.e = low.e;
            DiyFp too_high = buffer.too_high;
            too_high.f = high.f + unit;
            too_high.e = high.e;
            DiyFp unsafe_interval = buffer.unsafe_interval;
            unsafe_interval.f = too_high.f;
            unsafe_interval.e = too_high.e;
            unsafe_interval.subtract(too_low);
            DiyFp one = buffer.one;
            one.f = 1L << -w.e;
            one.e = w.e;
            int integrals = (int)(too_high.f >>> -one.e & 0xFFFFFFFFL);
            long fractionals = too_high.f & one.f - 1L;
            long result = FastDtoa.biggestPowerTen(integrals, 64 - -one.e);
            int divider = (int)(result >>> 32 & 0xFFFFFFFFL);
            int divider_exponent = (int)(result & 0xFFFFFFFFL);
            int kappa = divider_exponent + 1;
            while (kappa > 0) {
                digit = integrals / divider;
                buffer.append((byte)(48 + digit));
                --kappa;
                long rest = ((long)(integrals %= divider) << -one.e) + fractionals;
                if (rest < unsafe_interval.f) {
                    buffer.point = buffer.end - mk + kappa;
                    DiyFp minus_round = buffer.minus_round;
                    minus_round.f = too_high.f;
                    minus_round.e = too_high.e;
                    minus_round.subtract(w);
                    return FastDtoa.roundWeed(buffer, minus_round.f, unsafe_interval.f, rest, (long)divider << -one.e, unit);
                }
                divider /= 10;
            }
            do {
                fractionals *= 5L;
                unit *= 5L;
                unsafe_interval.f *= 5L;
                ++unsafe_interval.e;
                one.f >>>= 1;
                ++one.e;
                digit = (int)(fractionals >>> -one.e & 0xFFFFFFFFL);
                buffer.append((byte)(48 + digit));
                --kappa;
            } while ((fractionals &= one.f - 1L) >= unsafe_interval.f);
            buffer.point = buffer.end - mk + kappa;
            DiyFp minus_round = buffer.minus_round;
            minus_round.f = too_high.f;
            minus_round.e = too_high.e;
            minus_round.subtract(w);
            return FastDtoa.roundWeed(buffer, minus_round.f * unit, unsafe_interval.f, fractionals, one.f, unit);
        }
    }

    private static class DoubleHelper {
        static final long kExponentMask = 0x7FF0000000000000L;
        static final long kSignificandMask = 0xFFFFFFFFFFFFFL;
        static final long kHiddenBit = 0x10000000000000L;
        private static final int kSignificandSize = 52;
        private static final int kExponentBias = 1075;
        private static final int kDenormalExponent = -1074;

        private DoubleHelper() {
        }

        static void asDiyFp(long d64, DiyFp v) {
            v.f = DoubleHelper.significand(d64);
            v.e = DoubleHelper.exponent(d64);
        }

        static void asNormalizedDiyFp(long d64, DiyFp w) {
            long f = DoubleHelper.significand(d64);
            int e = DoubleHelper.exponent(d64);
            while ((f & 0x10000000000000L) == 0L) {
                f <<= 1;
                --e;
            }
            w.f = f <<= 11;
            w.e = e -= 11;
        }

        static int exponent(long d64) {
            if (DoubleHelper.isDenormal(d64)) {
                return -1074;
            }
            int biased_e = (int)((d64 & 0x7FF0000000000000L) >>> 52 & 0xFFFFFFFFL);
            return biased_e - 1075;
        }

        static long significand(long d64) {
            long significand = d64 & 0xFFFFFFFFFFFFFL;
            if (!DoubleHelper.isDenormal(d64)) {
                return significand + 0x10000000000000L;
            }
            return significand;
        }

        private static boolean isDenormal(long d64) {
            return (d64 & 0x7FF0000000000000L) == 0L;
        }

        static void normalizedBoundaries(DiyFp v, long d64, DiyFp m_minus, DiyFp m_plus) {
            DoubleHelper.asDiyFp(d64, v);
            boolean significand_is_zero = v.f == 0x10000000000000L;
            m_plus.f = (v.f << 1) + 1L;
            m_plus.e = v.e - 1;
            m_plus.normalize();
            if (significand_is_zero && v.e != -1074) {
                m_minus.f = (v.f << 2) - 1L;
                m_minus.e = v.e - 2;
            } else {
                m_minus.f = (v.f << 1) - 1L;
                m_minus.e = v.e - 1;
            }
            m_minus.f <<= m_minus.e - m_plus.e;
            m_minus.e = m_plus.e;
        }
    }

    private static class CachedPowers {
        static final double kD_1_LOG2_10 = 0.30102999566398114;
        static final int CACHED_POWERS_SPACING = 8;
        static final CachedPower[] CACHED_POWERS = new CachedPower[]{new CachedPower(-1865951482774665761L, -1087, -308), new CachedPower(-6093090917745768758L, -1060, -300), new CachedPower(-38366372719436721L, -1034, -292), new CachedPower(-4731433901725329908L, -1007, -284), new CachedPower(-8228041688891786180L, -980, -276), new CachedPower(-3219690930897053053L, -954, -268), new CachedPower(-7101705404292871755L, -927, -260), new CachedPower(-1541319077368263733L, -901, -252), new CachedPower(-5851220927660403859L, -874, -244), new CachedPower(-9062348037703676329L, -847, -236), new CachedPower(-4462904269766699465L, -821, -228), new CachedPower(-8027971522334779313L, -794, -220), new CachedPower(-2921563150702462265L, -768, -212), new CachedPower(-6879582898840692748L, -741, -204), new CachedPower(-1210330751515841307L, -715, -196), new CachedPower(-5604615407819967858L, -688, -188), new CachedPower(-8878612607581929669L, -661, -180), new CachedPower(-4189117143640191558L, -635, -172), new CachedPower(-7823984217374209642L, -608, -164), new CachedPower(-2617598379430861436L, -582, -156), new CachedPower(-6653111496142234890L, -555, -148), new CachedPower(-872862063775190746L, -529, -140), new CachedPower(-5353181642124984136L, -502, -132), new CachedPower(-8691279853972075893L, -475, -124), new CachedPower(-3909969587797413805L, -449, -116), new CachedPower(-7616003081050118571L, -422, -108), new CachedPower(-2307682335666372931L, -396, -100), new CachedPower(-6422206049907525489L, -369, -92), new CachedPower(-528786136287117932L, -343, -84), new CachedPower(-5096825099203863601L, -316, -76), new CachedPower(-8500279345513818773L, -289, -68), new CachedPower(-3625356651333078602L, -263, -60), new CachedPower(-7403949918844649556L, -236, -52), new CachedPower(-1991698500497491194L, -210, -44), new CachedPower(-6186779746782440749L, -183, -36), new CachedPower(-177973607073265138L, -157, -28), new CachedPower(-4835449396872013077L, -130, -20), new CachedPower(-8305539271883716404L, -103, -12), new CachedPower(-3335171328526686932L, -77, -4), new CachedPower(-7187745005283311616L, -50, 4), new CachedPower(-1669528073709551616L, -24, 12), new CachedPower(-5946744073709551616L, 3, 20), new CachedPower(-9133518327554766460L, 30, 28), new CachedPower(-4568956265895094861L, 56, 36), new CachedPower(-8106986416796705680L, 83, 44), new CachedPower(-3039304518611664792L, 109, 52), new CachedPower(-6967307053960650171L, 136, 60), new CachedPower(-1341049929119499481L, 162, 68), new CachedPower(-5702008784649933400L, 189, 76), new CachedPower(-8951176327949752869L, 216, 84), new CachedPower(-4297245513042813542L, 242, 92), new CachedPower(-7904546130479028392L, 269, 100), new CachedPower(-2737644984756826646L, 295, 108), new CachedPower(-6742553186979055798L, 322, 116), new CachedPower(-1006140569036166267L, 348, 124), new CachedPower(-5452481866653427593L, 375, 132), new CachedPower(-8765264286586255934L, 402, 140), new CachedPower(-4020214983419339459L, 428, 148), new CachedPower(-7698142301602209613L, 455, 156), new CachedPower(-2430079312244744221L, 481, 164), new CachedPower(-6513398903789220827L, 508, 172), new CachedPower(-664674077828931748L, 534, 180), new CachedPower(-5198069505264599346L, 561, 188), new CachedPower(-8575712306248138270L, 588, 196), new CachedPower(-3737760522056206171L, 614, 204), new CachedPower(-7487697328667536417L, 641, 212), new CachedPower(-2116491865831296966L, 667, 220), new CachedPower(-6279758049420528746L, 694, 228), new CachedPower(-316522074587315140L, 720, 236), new CachedPower(-4938676049251384304L, 747, 244), new CachedPower(-8382449121214030822L, 774, 252), new CachedPower(-3449775934753242068L, 800, 260), new CachedPower(-7273132090830278359L, 827, 268), new CachedPower(-1796764746270372707L, 853, 276), new CachedPower(-6041542782089432023L, 880, 284), new CachedPower(-9204148869281624187L, 907, 292), new CachedPower(-4674203974643163859L, 933, 300), new CachedPower(-8185402070463610993L, 960, 308), new CachedPower(-3156152948152813503L, 986, 316), new CachedPower(-7054365918152680535L, 1013, 324), new CachedPower(-1470777745987373095L, 1039, 332), new CachedPower(-5798663540173640085L, 1066, 340)};
        static final int GRISU_CACHE_OFFSET = 308;

        private CachedPowers() {
        }

        static int getCachedPower(int e, int alpha, DiyFp c_mk) {
            int kQ = 64;
            double k = Math.ceil((double)(alpha - e + 64 - 1) * 0.30102999566398114);
            int index = (308 + (int)k - 1) / 8 + 1;
            CachedPower cachedPower = CACHED_POWERS[index];
            c_mk.f = cachedPower.significand;
            c_mk.e = cachedPower.binaryExponent;
            return cachedPower.decimalExponent;
        }

        static class CachedPower {
            final long significand;
            final short binaryExponent;
            final short decimalExponent;

            CachedPower(long significand, short binaryExponent, short decimalExponent) {
                this.significand = significand;
                this.binaryExponent = binaryExponent;
                this.decimalExponent = decimalExponent;
            }
        }
    }

    private static final class DiyFp {
        long f = 0L;
        int e = 0;
        static final int kSignificandSize = 64;
        static final long kUint64MSB = Long.MIN_VALUE;
        private static final long kM32 = 0xFFFFFFFFL;
        private static final long k10MSBits = -18014398509481984L;

        DiyFp() {
        }

        void subtract(DiyFp other) {
            this.f -= other.f;
        }

        void multiply(DiyFp other) {
            long a = this.f >>> 32;
            long b = this.f & 0xFFFFFFFFL;
            long c = other.f >>> 32;
            long d = other.f & 0xFFFFFFFFL;
            long ac = a * c;
            long bc = b * c;
            long ad = a * d;
            long bd = b * d;
            long tmp = (bd >>> 32) + (ad & 0xFFFFFFFFL) + (bc & 0xFFFFFFFFL);
            long result_f = ac + (ad >>> 32) + (bc >>> 32) + ((tmp += 0x80000000L) >>> 32);
            this.e += other.e + 64;
            this.f = result_f;
        }

        void normalize() {
            long f = this.f;
            int e = this.e;
            while ((f & 0xFFC0000000000000L) == 0L) {
                f <<= 10;
                e -= 10;
            }
            while ((f & Long.MIN_VALUE) == 0L) {
                f <<= 1;
                --e;
            }
            this.f = f;
            this.e = e;
        }

        void reset() {
            this.e = 0;
            this.f = 0L;
        }

        public String toString() {
            return "[DiyFp f:" + this.f + ", e:" + this.e + "]";
        }
    }
}

