/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.jctools.queues;

import co.elastic.apm.agent.shaded.jctools.queues.LinkedArrayQueueUtil;
import co.elastic.apm.agent.shaded.jctools.queues.MpscChunkedArrayQueue;
import co.elastic.apm.agent.shaded.jctools.util.Pow2;
import co.elastic.apm.agent.shaded.jctools.util.RangeUtil;

public class MpscGrowableArrayQueue<E>
extends MpscChunkedArrayQueue<E> {
    public MpscGrowableArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(E[] buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(LinkedArrayQueueUtil.length(buffer), maxSize, "buffer.length");
        int newSize = 2 * (LinkedArrayQueueUtil.length(buffer) - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

