/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.stagemonitor.configuration;

import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOptionProvider;
import co.elastic.apm.agent.shaded.stagemonitor.configuration.source.ConfigurationSource;
import co.elastic.apm.agent.shaded.stagemonitor.util.CollectionUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ConfigurationRegistry
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ConfigurationSource> configurationSources = new CopyOnWriteArrayList<ConfigurationSource>();
    private final boolean failOnMissingRequiredValues;
    private Map<Class<? extends ConfigurationOptionProvider>, ConfigurationOptionProvider> optionProvidersByClass = new HashMap<Class<? extends ConfigurationOptionProvider>, ConfigurationOptionProvider>();
    private Map<String, ConfigurationOption<?>> configurationOptionsByKey = new LinkedHashMap();
    private Map<String, List<ConfigurationOption<?>>> configurationOptionsByCategory = new LinkedHashMap();
    private ScheduledExecutorService configurationReloader;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public ConfigurationRegistry(Iterable<? extends ConfigurationOptionProvider> optionProviders, List<ConfigurationSource> configSources) {
        this(optionProviders, configSources, false);
    }

    @Deprecated
    public ConfigurationRegistry(Iterable<? extends ConfigurationOptionProvider> optionProviders, List<ConfigurationSource> configSources, boolean failOnMissingRequiredValues) {
        this.failOnMissingRequiredValues = failOnMissingRequiredValues;
        this.configurationSources.addAll(configSources);
        this.registerConfigurationOptions(optionProviders);
    }

    private void registerConfigurationOptions(Iterable<? extends ConfigurationOptionProvider> optionProviders) {
        for (ConfigurationOptionProvider configurationOptionProvider : optionProviders) {
            this.registerOptionProvider(configurationOptionProvider);
        }
    }

    private void registerOptionProvider(ConfigurationOptionProvider configurationOptionProvider) {
        this.optionProvidersByClass.put(configurationOptionProvider.getClass(), configurationOptionProvider);
        for (ConfigurationOption<?> configurationOption : configurationOptionProvider.getConfigurationOptions()) {
            this.add(configurationOption);
        }
    }

    public <T extends ConfigurationOptionProvider> T getConfig(Class<T> configClass) {
        ConfigurationOptionProvider config = this.optionProvidersByClass.get(configClass);
        if (config != null) {
            return (T)config;
        }
        for (Class<? extends ConfigurationOptionProvider> storedConfigClass : this.optionProvidersByClass.keySet()) {
            if (!configClass.isAssignableFrom(storedConfigClass)) continue;
            return (T)this.optionProvidersByClass.get(storedConfigClass);
        }
        return null;
    }

    public Collection<ConfigurationOptionProvider> getConfigurationOptionProviders() {
        return Collections.unmodifiableCollection(this.optionProvidersByClass.values());
    }

    private void add(ConfigurationOption<?> configurationOption) {
        configurationOption.setConfiguration(this);
        configurationOption.setConfigurationSources(this.configurationSources);
        String key = configurationOption.getKey();
        this.addConfigurationOptionByKey(configurationOption, key);
        for (String alternateKey : configurationOption.getAliasKeys()) {
            this.addConfigurationOptionByKey(configurationOption, alternateKey);
        }
        this.addConfigurationOptionByCategory(configurationOption.getConfigurationCategory(), configurationOption);
    }

    private void addConfigurationOptionByKey(ConfigurationOption<?> configurationOption, String key) {
        if (this.configurationOptionsByKey.containsKey(key)) {
            throw new IllegalArgumentException(String.format("The configuration key %s is registered twice. Once for %s and once for %s.", key, this.configurationOptionsByKey.get(key).getLabel(), configurationOption.getLabel()));
        }
        this.configurationOptionsByKey.put(key, configurationOption);
    }

    private void addConfigurationOptionByCategory(String configurationCategory, final ConfigurationOption<?> configurationOption) {
        if (this.configurationOptionsByCategory.containsKey(configurationCategory)) {
            this.configurationOptionsByCategory.get(configurationCategory).add(configurationOption);
        } else {
            this.configurationOptionsByCategory.put(configurationCategory, new ArrayList<ConfigurationOption<?>>(){
                {
                    this.add(configurationOption);
                }
            });
        }
    }

    public Map<String, List<ConfigurationOption<?>>> getConfigurationOptionsByCategory() {
        return Collections.unmodifiableMap(this.configurationOptionsByCategory);
    }

    public Map<String, ConfigurationOption<?>> getConfigurationOptionsByKey() {
        return Collections.unmodifiableMap(this.configurationOptionsByKey);
    }

    public Map<String, Boolean> getNamesOfConfigurationSources() {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        for (ConfigurationSource configurationSource : this.configurationSources) {
            result.put(configurationSource.getName(), configurationSource.isSavingPossible());
        }
        return result;
    }

    public ConfigurationOption<?> getConfigurationOptionByKey(String key) {
        return this.configurationOptionsByKey.get(key);
    }

    public void scheduleReloadAtRate(final long rate, TimeUnit timeUnit) {
        this.initThreadPool();
        this.configurationReloader.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ConfigurationRegistry.this.logger.debug("Beginning scheduled configuration reload (interval is {} sec)...", (Object)rate);
                ConfigurationRegistry.this.reloadDynamicConfigurationOptions();
                ConfigurationRegistry.this.logger.debug("Finished scheduled configuration reload");
            }
        }, rate, rate, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initThreadPool() {
        ConfigurationRegistry configurationRegistry = this;
        synchronized (configurationRegistry) {
            if (this.configurationReloader == null) {
                this.configurationReloader = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r);
                        thread.setDaemon(true);
                        thread.setName("configuration-reloader");
                        return thread;
                    }
                });
            }
        }
    }

    public void reload(String key) {
        if (this.configurationOptionsByKey.containsKey(key)) {
            this.configurationOptionsByKey.get(key).reload(false);
        }
    }

    public void reloadAllConfigurationOptions() {
        this.reload(true);
    }

    public void reloadDynamicConfigurationOptions() {
        this.reload(false);
    }

    private void reload(boolean reloadNonDynamicValues) {
        for (ConfigurationSource configurationSource : this.configurationSources) {
            try {
                configurationSource.reload();
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage() + " (this exception is ignored)", e);
            }
        }
        for (ConfigurationOption configurationOption : this.configurationOptionsByKey.values()) {
            configurationOption.reload(reloadNonDynamicValues);
        }
    }

    public void addConfigurationSource(ConfigurationSource configurationSource) {
        this.addConfigurationSource(configurationSource, true);
    }

    public void addConfigurationSourceAfter(ConfigurationSource configurationSource, Class<? extends ConfigurationSource> addAfter) {
        if (configurationSource == null) {
            return;
        }
        CollectionUtils.addAfter(this.configurationSources, addAfter, configurationSource);
    }

    public void addConfigurationSource(ConfigurationSource configurationSource, boolean firstPrio) {
        if (configurationSource == null) {
            return;
        }
        if (firstPrio) {
            this.configurationSources.add(0, configurationSource);
        } else {
            this.configurationSources.add(configurationSource);
        }
    }

    public void save(String key, String value, String configurationSourceName) throws IOException {
        ConfigurationOption<?> configurationOption = this.validateConfigurationOption(key, value);
        this.saveToConfigurationSource(key, value, configurationSourceName, configurationOption);
    }

    private ConfigurationOption<?> validateConfigurationOption(String key, String value) throws IllegalArgumentException {
        ConfigurationOption<?> configurationOption = this.getConfigurationOptionByKey(key);
        if (configurationOption != null) {
            configurationOption.assertValid(value);
            return configurationOption;
        }
        throw new IllegalArgumentException("Config key '" + key + "' does not exist.");
    }

    private void saveToConfigurationSource(String key, String value, String configurationSourceName, ConfigurationOption<?> configurationOption) throws IOException {
        for (ConfigurationSource configurationSource : this.configurationSources) {
            if (configurationSourceName == null || !configurationSourceName.equals(configurationSource.getName())) continue;
            this.validateConfigurationSource(configurationSource, configurationOption);
            configurationSource.save(key, value);
            this.reload(key);
            this.logger.info("Updated configuration: {}={} ({})", key, value, configurationSourceName);
            return;
        }
        throw new IllegalArgumentException("Configuration source '" + configurationSourceName + "' does not exist.");
    }

    private void validateConfigurationSource(ConfigurationSource configurationSource, ConfigurationOption<?> configurationOption) {
        if (!configurationOption.isDynamic() && !configurationSource.isSavingPersistent()) {
            throw new IllegalArgumentException("Non dynamic options can't be saved to a transient configuration source.");
        }
    }

    public String getString(String key) {
        ConfigurationSource configurationSource;
        if (key == null || key.isEmpty()) {
            return null;
        }
        String property = null;
        Iterator<ConfigurationSource> iterator = this.configurationSources.iterator();
        while (iterator.hasNext() && (property = (configurationSource = iterator.next()).getValue(key)) == null) {
        }
        return property;
    }

    @Override
    public void close() {
        if (this.configurationReloader != null) {
            this.configurationReloader.shutdown();
        }
    }

    boolean isFailOnMissingRequiredValues() {
        return this.failOnMissingRequiredValues;
    }

    public static class Builder {
        private List<ConfigurationOptionProvider> optionProviders = new ArrayList<ConfigurationOptionProvider>();
        private List<ConfigurationSource> configSources = new ArrayList<ConfigurationSource>();
        private boolean failOnMissingRequiredValues = false;

        public Builder addOptionProvider(ConfigurationOptionProvider optionProvider) {
            this.optionProviders.add(optionProvider);
            return this;
        }

        public Builder optionProviders(Iterable<? extends ConfigurationOptionProvider> optionProviders) {
            for (ConfigurationOptionProvider configurationOptionProvider : optionProviders) {
                this.optionProviders.add(configurationOptionProvider);
            }
            return this;
        }

        public Builder addConfigSource(ConfigurationSource configurationSource) {
            this.configSources.add(configurationSource);
            return this;
        }

        public Builder configSources(List<? extends ConfigurationSource> configSources) {
            this.configSources.addAll(configSources);
            return this;
        }

        public Builder failOnMissingRequiredValues(boolean failOnMissingRequiredValues) {
            this.failOnMissingRequiredValues = failOnMissingRequiredValues;
            return this;
        }

        public ConfigurationRegistry build() {
            return new ConfigurationRegistry(this.optionProviders, this.configSources, this.failOnMissingRequiredValues);
        }
    }
}

