/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.spring.webmvc;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import java.util.Collection;
import java.util.Collections;
import org.springframework.web.context.WebApplicationContext;

public class SpringServiceNameInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameEndsWith("ApplicationContext");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.context.WebApplicationContext"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("initPropertySources").and(ElementMatchers.takesArguments(0));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("spring-service-name");
    }

    @Override
    public Class<?> getAdviceClass() {
        return SpringServiceNameAdvice.class;
    }

    public static class SpringServiceNameAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void afterInitPropertySources(@Advice.This WebApplicationContext applicationContext) {
            if (ElasticApmInstrumentation.tracer != null && applicationContext.getServletContext() != null) {
                ElasticApmInstrumentation.tracer.overrideServiceNameForClassLoader(applicationContext.getServletContext().getClassLoader(), applicationContext.getEnvironment().getProperty("spring.application.name"));
            }
        }
    }
}

