/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.urlconnection;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import co.elastic.apm.agent.util.DataStructures;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class HttpUrlConnectionInstrumentation
extends ElasticApmInstrumentation {
    public static final WeakConcurrentMap<HttpURLConnection, Span> inFlightSpans = DataStructures.createWeakConcurrentMapWithCleanerThread();

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "urlconnection");
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("URLConnection").or(ElementMatchers.nameContains("UrlConnection"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.is(HttpURLConnection.class));
    }

    public static class DisconnectInstrumentation
    extends HttpUrlConnectionInstrumentation {
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void afterDisconnect(@Advice.This HttpURLConnection thiz, @Nullable @Advice.Thrown Throwable t, @Advice.FieldValue(value="responseCode") int responseCode) {
            Span span = (Span)inFlightSpans.remove(thiz);
            if (span != null) {
                ((Span)span.captureException(t)).end();
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("disconnect").and(ElementMatchers.takesArguments(0));
        }
    }

    public static class CreateSpanInstrumentation
    extends HttpUrlConnectionInstrumentation {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void enter(@Advice.This HttpURLConnection thiz, @Advice.FieldValue(value="connected") boolean connected, @Advice.Local(value="span") Span span, @Advice.Origin String signature) {
            if (tracer == null || tracer.getActive() == null) {
                return;
            }
            span = (Span)inFlightSpans.get(thiz);
            if (span == null && !connected) {
                URL url = thiz.getURL();
                span = HttpClientHelper.startHttpClientSpan(tracer.getActive(), thiz.getRequestMethod(), url.toString(), url.getProtocol(), url.getHost(), url.getPort());
                if (span != null && thiz.getRequestProperty("elastic-apm-traceparent") == null) {
                    thiz.addRequestProperty("elastic-apm-traceparent", span.getTraceContext().getOutgoingTraceParentTextHeader().toString());
                }
            }
            if (span != null) {
                span.activate();
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void exit(@Advice.This HttpURLConnection thiz, @Nullable @Advice.Thrown Throwable t, @Advice.FieldValue(value="responseCode") int responseCode, @Nullable @Advice.Local(value="span") Span span, @Advice.Origin String signature) {
            if (span == null) {
                return;
            }
            span.deactivate();
            if (responseCode != -1) {
                inFlightSpans.remove(thiz);
                span.getContext().getHttp().withStatusCode(responseCode);
                ((Span)span.captureException(t)).end();
            } else if (t != null) {
                inFlightSpans.remove(thiz);
                ((Span)span.captureException(t)).end();
            } else {
                inFlightSpans.put(thiz, span);
            }
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("connect").and(ElementMatchers.takesArguments(0)).or(ElementMatchers.named("getOutputStream").and(ElementMatchers.takesArguments(0))).or(ElementMatchers.named("getInputStream").and(ElementMatchers.takesArguments(0)));
        }
    }
}

