/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexingStats
implements JsonpSerializable {
    private final long indexCurrent;
    private final long deleteCurrent;
    @Nullable
    private final Time deleteTime;
    private final long deleteTimeInMillis;
    private final long deleteTotal;
    private final boolean isThrottled;
    private final long noopUpdateTotal;
    @Nullable
    private final Time throttleTime;
    private final long throttleTimeInMillis;
    @Nullable
    private final Time indexTime;
    private final long indexTimeInMillis;
    private final long indexTotal;
    private final long indexFailed;
    private final Map<String, IndexingStats> types;
    @Nullable
    private final Double writeLoad;
    public static final JsonpDeserializer<IndexingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexingStats::setupIndexingStatsDeserializer);

    private IndexingStats(Builder builder) {
        this.indexCurrent = ApiTypeHelper.requireNonNull(builder.indexCurrent, (Object)this, "indexCurrent", 0L);
        this.deleteCurrent = ApiTypeHelper.requireNonNull(builder.deleteCurrent, (Object)this, "deleteCurrent", 0L);
        this.deleteTime = builder.deleteTime;
        this.deleteTimeInMillis = ApiTypeHelper.requireNonNull(builder.deleteTimeInMillis, (Object)this, "deleteTimeInMillis", 0L);
        this.deleteTotal = ApiTypeHelper.requireNonNull(builder.deleteTotal, (Object)this, "deleteTotal", 0L);
        this.isThrottled = ApiTypeHelper.requireNonNull(builder.isThrottled, (Object)this, "isThrottled", false);
        this.noopUpdateTotal = ApiTypeHelper.requireNonNull(builder.noopUpdateTotal, (Object)this, "noopUpdateTotal", 0L);
        this.throttleTime = builder.throttleTime;
        this.throttleTimeInMillis = ApiTypeHelper.requireNonNull(builder.throttleTimeInMillis, (Object)this, "throttleTimeInMillis", 0L);
        this.indexTime = builder.indexTime;
        this.indexTimeInMillis = ApiTypeHelper.requireNonNull(builder.indexTimeInMillis, (Object)this, "indexTimeInMillis", 0L);
        this.indexTotal = ApiTypeHelper.requireNonNull(builder.indexTotal, (Object)this, "indexTotal", 0L);
        this.indexFailed = ApiTypeHelper.requireNonNull(builder.indexFailed, (Object)this, "indexFailed", 0L);
        this.types = ApiTypeHelper.unmodifiable(builder.types);
        this.writeLoad = builder.writeLoad;
    }

    public static IndexingStats of(Function<Builder, ObjectBuilder<IndexingStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long indexCurrent() {
        return this.indexCurrent;
    }

    public final long deleteCurrent() {
        return this.deleteCurrent;
    }

    @Nullable
    public final Time deleteTime() {
        return this.deleteTime;
    }

    public final long deleteTimeInMillis() {
        return this.deleteTimeInMillis;
    }

    public final long deleteTotal() {
        return this.deleteTotal;
    }

    public final boolean isThrottled() {
        return this.isThrottled;
    }

    public final long noopUpdateTotal() {
        return this.noopUpdateTotal;
    }

    @Nullable
    public final Time throttleTime() {
        return this.throttleTime;
    }

    public final long throttleTimeInMillis() {
        return this.throttleTimeInMillis;
    }

    @Nullable
    public final Time indexTime() {
        return this.indexTime;
    }

    public final long indexTimeInMillis() {
        return this.indexTimeInMillis;
    }

    public final long indexTotal() {
        return this.indexTotal;
    }

    public final long indexFailed() {
        return this.indexFailed;
    }

    public final Map<String, IndexingStats> types() {
        return this.types;
    }

    @Nullable
    public final Double writeLoad() {
        return this.writeLoad;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_current");
        generator.write(this.indexCurrent);
        generator.writeKey("delete_current");
        generator.write(this.deleteCurrent);
        if (this.deleteTime != null) {
            generator.writeKey("delete_time");
            this.deleteTime.serialize(generator, mapper);
        }
        generator.writeKey("delete_time_in_millis");
        generator.write(this.deleteTimeInMillis);
        generator.writeKey("delete_total");
        generator.write(this.deleteTotal);
        generator.writeKey("is_throttled");
        generator.write(this.isThrottled);
        generator.writeKey("noop_update_total");
        generator.write(this.noopUpdateTotal);
        if (this.throttleTime != null) {
            generator.writeKey("throttle_time");
            this.throttleTime.serialize(generator, mapper);
        }
        generator.writeKey("throttle_time_in_millis");
        generator.write(this.throttleTimeInMillis);
        if (this.indexTime != null) {
            generator.writeKey("index_time");
            this.indexTime.serialize(generator, mapper);
        }
        generator.writeKey("index_time_in_millis");
        generator.write(this.indexTimeInMillis);
        generator.writeKey("index_total");
        generator.write(this.indexTotal);
        generator.writeKey("index_failed");
        generator.write(this.indexFailed);
        if (ApiTypeHelper.isDefined(this.types)) {
            generator.writeKey("types");
            generator.writeStartObject();
            for (Map.Entry<String, IndexingStats> item0 : this.types.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.writeLoad != null) {
            generator.writeKey("write_load");
            generator.write(this.writeLoad.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexingStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexCurrent, JsonpDeserializer.longDeserializer(), "index_current");
        op.add(Builder::deleteCurrent, JsonpDeserializer.longDeserializer(), "delete_current");
        op.add(Builder::deleteTime, Time._DESERIALIZER, "delete_time");
        op.add(Builder::deleteTimeInMillis, JsonpDeserializer.longDeserializer(), "delete_time_in_millis");
        op.add(Builder::deleteTotal, JsonpDeserializer.longDeserializer(), "delete_total");
        op.add(Builder::isThrottled, JsonpDeserializer.booleanDeserializer(), "is_throttled");
        op.add(Builder::noopUpdateTotal, JsonpDeserializer.longDeserializer(), "noop_update_total");
        op.add(Builder::throttleTime, Time._DESERIALIZER, "throttle_time");
        op.add(Builder::throttleTimeInMillis, JsonpDeserializer.longDeserializer(), "throttle_time_in_millis");
        op.add(Builder::indexTime, Time._DESERIALIZER, "index_time");
        op.add(Builder::indexTimeInMillis, JsonpDeserializer.longDeserializer(), "index_time_in_millis");
        op.add(Builder::indexTotal, JsonpDeserializer.longDeserializer(), "index_total");
        op.add(Builder::indexFailed, JsonpDeserializer.longDeserializer(), "index_failed");
        op.add(Builder::types, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "types");
        op.add(Builder::writeLoad, JsonpDeserializer.doubleDeserializer(), "write_load");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexingStats> {
        private Long indexCurrent;
        private Long deleteCurrent;
        @Nullable
        private Time deleteTime;
        private Long deleteTimeInMillis;
        private Long deleteTotal;
        private Boolean isThrottled;
        private Long noopUpdateTotal;
        @Nullable
        private Time throttleTime;
        private Long throttleTimeInMillis;
        @Nullable
        private Time indexTime;
        private Long indexTimeInMillis;
        private Long indexTotal;
        private Long indexFailed;
        @Nullable
        private Map<String, IndexingStats> types;
        @Nullable
        private Double writeLoad;

        public final Builder indexCurrent(long value) {
            this.indexCurrent = value;
            return this;
        }

        public final Builder deleteCurrent(long value) {
            this.deleteCurrent = value;
            return this;
        }

        public final Builder deleteTime(@Nullable Time value) {
            this.deleteTime = value;
            return this;
        }

        public final Builder deleteTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.deleteTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder deleteTimeInMillis(long value) {
            this.deleteTimeInMillis = value;
            return this;
        }

        public final Builder deleteTotal(long value) {
            this.deleteTotal = value;
            return this;
        }

        public final Builder isThrottled(boolean value) {
            this.isThrottled = value;
            return this;
        }

        public final Builder noopUpdateTotal(long value) {
            this.noopUpdateTotal = value;
            return this;
        }

        public final Builder throttleTime(@Nullable Time value) {
            this.throttleTime = value;
            return this;
        }

        public final Builder throttleTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttleTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder throttleTimeInMillis(long value) {
            this.throttleTimeInMillis = value;
            return this;
        }

        public final Builder indexTime(@Nullable Time value) {
            this.indexTime = value;
            return this;
        }

        public final Builder indexTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.indexTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder indexTimeInMillis(long value) {
            this.indexTimeInMillis = value;
            return this;
        }

        public final Builder indexTotal(long value) {
            this.indexTotal = value;
            return this;
        }

        public final Builder indexFailed(long value) {
            this.indexFailed = value;
            return this;
        }

        public final Builder types(Map<String, IndexingStats> map) {
            this.types = Builder._mapPutAll(this.types, map);
            return this;
        }

        public final Builder types(String key, IndexingStats value) {
            this.types = Builder._mapPut(this.types, key, value);
            return this;
        }

        public final Builder types(String key, Function<Builder, ObjectBuilder<IndexingStats>> fn) {
            return this.types(key, fn.apply(new Builder()).build());
        }

        public final Builder writeLoad(@Nullable Double value) {
            this.writeLoad = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexingStats build() {
            this._checkSingleUse();
            return new IndexingStats(this);
        }
    }
}

