/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch.rollup.DateHistogramGrouping;
import co.elastic.clients.elasticsearch.rollup.HistogramGrouping;
import co.elastic.clients.elasticsearch.rollup.TermsGrouping;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Groupings
implements JsonpSerializable {
    @Nullable
    private final DateHistogramGrouping dateHistogram;
    @Nullable
    private final HistogramGrouping histogram;
    @Nullable
    private final TermsGrouping terms;
    public static final JsonpDeserializer<Groupings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Groupings::setupGroupingsDeserializer);

    private Groupings(Builder builder) {
        this.dateHistogram = builder.dateHistogram;
        this.histogram = builder.histogram;
        this.terms = builder.terms;
    }

    public static Groupings of(Function<Builder, ObjectBuilder<Groupings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateHistogramGrouping dateHistogram() {
        return this.dateHistogram;
    }

    @Nullable
    public final HistogramGrouping histogram() {
        return this.histogram;
    }

    @Nullable
    public final TermsGrouping terms() {
        return this.terms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dateHistogram != null) {
            generator.writeKey("date_histogram");
            this.dateHistogram.serialize(generator, mapper);
        }
        if (this.histogram != null) {
            generator.writeKey("histogram");
            this.histogram.serialize(generator, mapper);
        }
        if (this.terms != null) {
            generator.writeKey("terms");
            this.terms.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGroupingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dateHistogram, DateHistogramGrouping._DESERIALIZER, "date_histogram");
        op.add(Builder::histogram, HistogramGrouping._DESERIALIZER, "histogram");
        op.add(Builder::terms, TermsGrouping._DESERIALIZER, "terms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Groupings> {
        @Nullable
        private DateHistogramGrouping dateHistogram;
        @Nullable
        private HistogramGrouping histogram;
        @Nullable
        private TermsGrouping terms;

        public final Builder dateHistogram(@Nullable DateHistogramGrouping value) {
            this.dateHistogram = value;
            return this;
        }

        public final Builder dateHistogram(Function<DateHistogramGrouping.Builder, ObjectBuilder<DateHistogramGrouping>> fn) {
            return this.dateHistogram(fn.apply(new DateHistogramGrouping.Builder()).build());
        }

        public final Builder histogram(@Nullable HistogramGrouping value) {
            this.histogram = value;
            return this;
        }

        public final Builder histogram(Function<HistogramGrouping.Builder, ObjectBuilder<HistogramGrouping>> fn) {
            return this.histogram(fn.apply(new HistogramGrouping.Builder()).build());
        }

        public final Builder terms(@Nullable TermsGrouping value) {
            this.terms = value;
            return this;
        }

        public final Builder terms(Function<TermsGrouping.Builder, ObjectBuilder<TermsGrouping>> fn) {
            return this.terms(fn.apply(new TermsGrouping.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Groupings build() {
            this._checkSingleUse();
            return new Groupings(this);
        }
    }
}

