/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OpenAIServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    @Nullable
    private final Integer dimensions;
    private final String modelId;
    @Nullable
    private final String organizationId;
    @Nullable
    private final RateLimitSetting rateLimit;
    @Nullable
    private final String url;
    public static final JsonpDeserializer<OpenAIServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenAIServiceSettings::setupOpenAIServiceSettingsDeserializer);

    private OpenAIServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.dimensions = builder.dimensions;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.organizationId = builder.organizationId;
        this.rateLimit = builder.rateLimit;
        this.url = builder.url;
    }

    public static OpenAIServiceSettings of(Function<Builder, ObjectBuilder<OpenAIServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    @Nullable
    public final Integer dimensions() {
        return this.dimensions;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String organizationId() {
        return this.organizationId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Nullable
    public final String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        if (this.dimensions != null) {
            generator.writeKey("dimensions");
            generator.write(this.dimensions.intValue());
        }
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.organizationId != null) {
            generator.writeKey("organization_id");
            generator.write(this.organizationId);
        }
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        if (this.url != null) {
            generator.writeKey("url");
            generator.write(this.url);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupOpenAIServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::dimensions, JsonpDeserializer.integerDeserializer(), "dimensions");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::organizationId, JsonpDeserializer.stringDeserializer(), "organization_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OpenAIServiceSettings> {
        private String apiKey;
        @Nullable
        private Integer dimensions;
        private String modelId;
        @Nullable
        private String organizationId;
        @Nullable
        private RateLimitSetting rateLimit;
        @Nullable
        private String url;

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder dimensions(@Nullable Integer value) {
            this.dimensions = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder organizationId(@Nullable String value) {
            this.organizationId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder url(@Nullable String value) {
            this.url = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OpenAIServiceSettings build() {
            this._checkSingleUse();
            return new OpenAIServiceSettings(this);
        }
    }
}

