/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.InferenceConfig;
import co.elastic.clients.elasticsearch.ingest.InferenceConfigVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceConfigRegression
implements InferenceConfigVariant,
JsonpSerializable {
    @Nullable
    private final String resultsField;
    @Nullable
    private final Integer numTopFeatureImportanceValues;
    public static final JsonpDeserializer<InferenceConfigRegression> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceConfigRegression::setupInferenceConfigRegressionDeserializer);

    private InferenceConfigRegression(Builder builder) {
        this.resultsField = builder.resultsField;
        this.numTopFeatureImportanceValues = builder.numTopFeatureImportanceValues;
    }

    public static InferenceConfigRegression of(Function<Builder, ObjectBuilder<InferenceConfigRegression>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfig.Kind _inferenceConfigKind() {
        return InferenceConfig.Kind.Regression;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public final Integer numTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.numTopFeatureImportanceValues != null) {
            generator.writeKey("num_top_feature_importance_values");
            generator.write(this.numTopFeatureImportanceValues.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInferenceConfigRegressionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::numTopFeatureImportanceValues, JsonpDeserializer.integerDeserializer(), "num_top_feature_importance_values");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceConfigRegression> {
        @Nullable
        private String resultsField;
        @Nullable
        private Integer numTopFeatureImportanceValues;

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder numTopFeatureImportanceValues(@Nullable Integer value) {
            this.numTopFeatureImportanceValues = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceConfigRegression build() {
            this._checkSingleUse();
            return new InferenceConfigRegression(this);
        }
    }
}

