/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.ml.JobStatistics;
import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceDeploymentsTimeMs;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MlInferenceDeployments
implements JsonpSerializable {
    private final int count;
    private final JobStatistics inferenceCounts;
    private final JobStatistics modelSizesBytes;
    private final MlInferenceDeploymentsTimeMs timeMs;
    public static final JsonpDeserializer<MlInferenceDeployments> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInferenceDeployments::setupMlInferenceDeploymentsDeserializer);

    private MlInferenceDeployments(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.inferenceCounts = ApiTypeHelper.requireNonNull(builder.inferenceCounts, this, "inferenceCounts");
        this.modelSizesBytes = ApiTypeHelper.requireNonNull(builder.modelSizesBytes, this, "modelSizesBytes");
        this.timeMs = ApiTypeHelper.requireNonNull(builder.timeMs, this, "timeMs");
    }

    public static MlInferenceDeployments of(Function<Builder, ObjectBuilder<MlInferenceDeployments>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    public final JobStatistics inferenceCounts() {
        return this.inferenceCounts;
    }

    public final JobStatistics modelSizesBytes() {
        return this.modelSizesBytes;
    }

    public final MlInferenceDeploymentsTimeMs timeMs() {
        return this.timeMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("inference_counts");
        this.inferenceCounts.serialize(generator, mapper);
        generator.writeKey("model_sizes_bytes");
        this.modelSizesBytes.serialize(generator, mapper);
        generator.writeKey("time_ms");
        this.timeMs.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMlInferenceDeploymentsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::inferenceCounts, JobStatistics._DESERIALIZER, "inference_counts");
        op.add(Builder::modelSizesBytes, JobStatistics._DESERIALIZER, "model_sizes_bytes");
        op.add(Builder::timeMs, MlInferenceDeploymentsTimeMs._DESERIALIZER, "time_ms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MlInferenceDeployments> {
        private Integer count;
        private JobStatistics inferenceCounts;
        private JobStatistics modelSizesBytes;
        private MlInferenceDeploymentsTimeMs timeMs;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder inferenceCounts(JobStatistics value) {
            this.inferenceCounts = value;
            return this;
        }

        public final Builder inferenceCounts(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.inferenceCounts(fn.apply(new JobStatistics.Builder()).build());
        }

        public final Builder modelSizesBytes(JobStatistics value) {
            this.modelSizesBytes = value;
            return this;
        }

        public final Builder modelSizesBytes(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.modelSizesBytes(fn.apply(new JobStatistics.Builder()).build());
        }

        public final Builder timeMs(MlInferenceDeploymentsTimeMs value) {
            this.timeMs = value;
            return this;
        }

        public final Builder timeMs(Function<MlInferenceDeploymentsTimeMs.Builder, ObjectBuilder<MlInferenceDeploymentsTimeMs>> fn) {
            return this.timeMs(fn.apply(new MlInferenceDeploymentsTimeMs.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MlInferenceDeployments build() {
            this._checkSingleUse();
            return new MlInferenceDeployments(this);
        }
    }
}

